/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.python.PythonProcess;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.GatewayServer;

public class PythonInterpreter
extends Interpreter {
    private static final Logger LOG = LoggerFactory.getLogger(PythonInterpreter.class);
    public static final String BOOTSTRAP_PY = "/bootstrap.py";
    public static final String BOOTSTRAP_INPUT_PY = "/bootstrap_input.py";
    public static final String ZEPPELIN_PYTHON = "zeppelin.python";
    public static final String DEFAULT_ZEPPELIN_PYTHON = "python";
    public static final String MAX_RESULT = "zeppelin.python.maxResult";
    private Integer port;
    private GatewayServer gatewayServer;
    private Boolean py4JisInstalled = false;
    private InterpreterContext context;
    private Pattern errorInLastLine = Pattern.compile(".*(Error|Exception): .*$");
    private String pythonPath;
    private int maxResult;
    PythonProcess process = null;
    private String pythonCommand = null;

    public PythonInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        InterpreterGroup intpGroup = this.getInterpreterGroup();
        if (intpGroup != null && intpGroup.getInterpreterHookRegistry() != null) {
            this.registerHook("post_exec_dev", "\nz._displayhook()");
        }
        this.setPythonPath("../interpreter/lib/python:$PYTHONPATH");
        LOG.info("Starting Python interpreter ---->");
        LOG.info("Python path is set to:" + this.property.getProperty(ZEPPELIN_PYTHON));
        this.maxResult = Integer.valueOf(this.getProperty(MAX_RESULT));
        this.process = this.getPythonProcess();
        try {
            this.process.open();
        }
        catch (IOException e) {
            LOG.error("Can't start the python process", (Throwable)e);
        }
        try {
            LOG.info("python PID : " + this.process.getPid());
        }
        catch (Exception e) {
            LOG.warn("Can't find python pid process", (Throwable)e);
        }
        try {
            LOG.info("Bootstrap interpreter with /bootstrap.py");
            this.bootStrapInterpreter(BOOTSTRAP_PY);
        }
        catch (IOException e) {
            LOG.error("Can't execute /bootstrap.py to initiate python process", (Throwable)e);
        }
        this.py4JisInstalled = this.isPy4jInstalled();
        if (this.py4JisInstalled.booleanValue()) {
            this.port = this.findRandomOpenPortOnAllLocalInterfaces();
            LOG.info("Py4j gateway port : " + this.port);
            try {
                this.gatewayServer = new GatewayServer((Object)this, this.port.intValue());
                this.gatewayServer.start();
                LOG.info("Bootstrap inputs with /bootstrap_input.py");
                this.bootStrapInterpreter(BOOTSTRAP_INPUT_PY);
            }
            catch (IOException e) {
                LOG.error("Can't execute /bootstrap_input.py to initialize Zeppelin inputs in python process", (Throwable)e);
            }
        }
    }

    public void close() {
        LOG.info("closing Python interpreter <----");
        try {
            if (this.process != null) {
                this.process.close();
                this.process = null;
            }
            if (this.gatewayServer != null) {
                this.gatewayServer.shutdown();
            }
        }
        catch (IOException e) {
            LOG.error("Can't close the interpreter", (Throwable)e);
        }
    }

    public InterpreterResult interpret(String cmd, InterpreterContext contextInterpreter) {
        if (cmd == null || cmd.isEmpty()) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, "");
        }
        this.context = contextInterpreter;
        String output = this.sendCommandToPython(cmd);
        InterpreterResult result = this.pythonErrorIn(output) ? new InterpreterResult(InterpreterResult.Code.ERROR, output.replaceAll("\\.\\.\\.", "")) : new InterpreterResult(InterpreterResult.Code.SUCCESS, output);
        return result;
    }

    private boolean pythonErrorIn(String output) {
        String[] outputMultiline;
        boolean isError = false;
        for (String row : outputMultiline = output.split("\n")) {
            Matcher errorMatcher = this.errorInLastLine.matcher(row);
            if (!errorMatcher.find()) continue;
            isError = true;
            break;
        }
        return isError;
    }

    public void cancel(InterpreterContext context) {
        try {
            this.process.interrupt();
        }
        catch (IOException e) {
            LOG.error("Can't interrupt the python interpreter", (Throwable)e);
        }
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(PythonInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    public List<InterpreterCompletion> completion(String buf, int cursor) {
        return null;
    }

    public void setPythonPath(String pythonPath) {
        this.pythonPath = pythonPath;
    }

    public PythonProcess getPythonProcess() {
        if (this.process == null) {
            String binPath = this.getProperty(ZEPPELIN_PYTHON);
            if (this.pythonCommand != null) {
                binPath = this.pythonCommand;
            }
            return new PythonProcess(binPath, this.pythonPath);
        }
        return this.process;
    }

    public void setPythonCommand(String cmd) {
        this.pythonCommand = cmd;
    }

    public String getPythonCommand() {
        return this.pythonCommand;
    }

    private Job getRunningJob(String paragraphId) {
        Job foundJob = null;
        Collection jobsRunning = this.getScheduler().getJobsRunning();
        for (Job job : jobsRunning) {
            if (!job.getId().equals(paragraphId)) continue;
            foundJob = job;
            break;
        }
        return foundJob;
    }

    String sendCommandToPython(String cmd) {
        String output = "";
        LOG.debug("Sending : \n" + (cmd.length() > 200 ? cmd.substring(0, 200) + "..." : cmd));
        try {
            output = this.process.sendAndGetResult(cmd);
        }
        catch (IOException e) {
            LOG.error("Error when sending commands to python process", (Throwable)e);
        }
        LOG.debug("Got : \n" + output);
        return output;
    }

    void bootStrapInterpreter(String file) throws IOException {
        BufferedReader bootstrapReader = new BufferedReader(new InputStreamReader(PythonInterpreter.class.getResourceAsStream(file)));
        String line = null;
        String bootstrapCode = "";
        while ((line = bootstrapReader.readLine()) != null) {
            bootstrapCode = bootstrapCode + line + "\n";
        }
        if (this.py4JisInstalled.booleanValue() && this.port != null && this.port != -1) {
            bootstrapCode = bootstrapCode.replaceAll("\\%PORT\\%", this.port.toString());
        }
        LOG.info("Bootstrap python interpreter with code from \n " + file);
        this.sendCommandToPython(bootstrapCode);
    }

    public GUI getGui() {
        return this.context.getGui();
    }

    public Integer getPy4jPort() {
        return this.port;
    }

    public Boolean isPy4jInstalled() {
        String output = this.sendCommandToPython("\n\nimport py4j\n");
        return !output.contains("ImportError");
    }

    private int findRandomOpenPortOnAllLocalInterfaces() {
        Integer port = -1;
        try (ServerSocket socket = new ServerSocket(0);){
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            LOG.error("Can't find an open port", (Throwable)e);
        }
        return port;
    }

    public int getMaxResult() {
        return this.maxResult;
    }
}

