/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.biojava.nbio.alignment.io.StockholmFileAnnotation;
import org.biojava.nbio.alignment.io.StockholmStructure;
import org.biojava.nbio.core.exceptions.ParserException;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockholmFileParser {
    private static final Logger logger = LoggerFactory.getLogger(StockholmFileParser.class);
    public static final int INFINITY = -1;
    private static final String GENERIC_PER_FILE_ANNOTATION = "GF";
    private static final String GENERIC_PER_CONSENSUS_ANNOTATION = "GC";
    private static final String GENERIC_PER_SEQUENCE_ANNOTATION = "GS";
    private static final String GENERIC_PER_RESIDUE_ANNOTATION = "GR";
    private static final String GF_ACCESSION_NUMBER = "AC";
    private static final String GF_IDENTIFICATION = "ID";
    private static final String GF_DEFINITION = "DE";
    private static final String GF_AUTHOR = "AU";
    private static final String GF_ALIGNMENT_METHOD = "AM";
    private static final String GF_BUILD_METHOD = "BM";
    private static final String GF_SEARCH_METHOD = "SM";
    private static final String GF_SOURCE_SEED = "SE";
    private static final String GF_SOURCE_STRUCTURE = "SS";
    private static final String GF_GATHERING_THRESHOLD = "GA";
    private static final String GF_TRUSTED_CUTOFF = "TC";
    private static final String GF_NOISE_CUTOFF = "NC";
    private static final String GF_TYPE_FIELD = "TP";
    private static final String GF_SEQUENCE = "SQ";
    private static final String GF_DB_COMMENT = "DC";
    private static final String GF_DB_REFERENCE = "DR";
    private static final String GF_REFERENCE_COMMENT = "RC";
    private static final String GF_REFERENCE_NUMBER = "RN";
    private static final String GF_REFERENCE_MEDLINE = "RM";
    private static final String GF_REFERENCE_TITLE = "RT";
    private static final String GF_REFERENCE_AUTHOR = "RA";
    private static final String GF_REFERENCE_LOCALTION = "RL";
    private static final String GF_PREVIOUS_IDS = "PI";
    private static final String GF_KEYWORDS = "KW";
    private static final String GF_COMMENT = "CC";
    private static final String GF_PFAM_ACCESSION = "NE";
    private static final String GF_LOCATION = "NL";
    private static final String GF_WIKIPEDIA_LINK = "WK";
    private static final String GF_CLAN = "CL";
    private static final String GF_MEMBERSHIP = "MB";
    private static final String GF_NEW_HAMPSHIRE = "NH";
    private static final String GF_TREE_ID = "TN";
    private static final String GF_FALSE_DISCOVERY_RATE = "FR";
    private static final String GS_ACCESSION_NUMBER = "AC";
    private static final String GS_DESCRIPTION = "DE";
    private static final String GS_DATABASE_REFERENCE = "DR";
    private static final String GS_ORGANISM_SPECIES = "OS";
    private static final String GS_ORGANISM_CLASSIFICATION = "OC";
    private static final String GS_LOOK = "LO";
    private static final String GR_SECONDARY_STRUCTURE = "SS";
    private static final String GR_SURFACE_ACCESSIBILITY = "SA";
    private static final String GR_TRANS_MEMBRANE = "TM";
    private static final String GR_POSTERIOR_PROBABILITY = "PP";
    private static final String GR_LIGAND_BINDING = "LI";
    private static final String GR_ACTIVE_SITE = "AS";
    private static final String GR_AS_PFAM_PREDICTED = "pAS";
    private static final String GR_AS_SWISSPROT = "sAS";
    private static final String GR_INTRON = "IN";
    private static final String GC_SEQUENSE_CONSENSUS = "seq_cons";
    private static final String GC_SECONDARY_STRUCTURE = "SS_cons";
    private static final String GC_SURFACE_ACCESSIBILITY = "SA_cons";
    private static final String GC_TRANS_MEMBRANE = "TM_cons";
    private static final String GC_POSTERIOR_PROBABILITY = "PP_cons";
    private static final String GC_LIGAND_BINDING = "LI_cons";
    private static final String GC_ACTIVE_SITE = "AS_cons";
    private static final String GC_AS_PFAM_PREDICTED = "pAS_cons";
    private static final String GC_AS_SWISSPROT = "sAS_cons";
    private static final String GC_INTRON = "IN_cons";
    private static final String GC_REFERENCE_ANNOTATION = "RF";
    private static final String GC_MODEL_MASK = "MM";
    private StockholmStructure stockholmStructure;
    Scanner internalScanner = null;
    private InputStream cashedInputStream;

    public StockholmStructure parse(String filename) throws IOException {
        InputStream inStream = new InputStreamProvider().getInputStream(filename);
        StockholmStructure structure = this.parse(inStream);
        inStream.close();
        return structure;
    }

    public List<StockholmStructure> parse(String filename, int max) throws IOException {
        InputStreamProvider isp = new InputStreamProvider();
        InputStream inStream = isp.getInputStream(filename);
        return this.parse(inStream, max);
    }

    public StockholmStructure parse(InputStream inStream) throws IOException {
        return this.parse(inStream, 1).get(0);
    }

    public List<StockholmStructure> parse(InputStream inStream, int max) throws IOException {
        StockholmStructure structure;
        if (max < -1) {
            throw new IllegalArgumentException("max can't be -ve value " + max);
        }
        if (inStream != this.cashedInputStream) {
            this.cashedInputStream = inStream;
            this.internalScanner = null;
        }
        if (this.internalScanner == null) {
            this.internalScanner = new Scanner(inStream);
        }
        ArrayList<StockholmStructure> structures = new ArrayList<StockholmStructure>();
        while (max != -1 && max-- > 0 && (structure = this.parse(this.internalScanner)) != null) {
            structures.add(structure);
        }
        return structures;
    }

    public List<StockholmStructure> parseNext(int max) throws IOException {
        return this.parse(this.cashedInputStream, max);
    }

    StockholmStructure parse(Scanner scanner) throws IOException {
        if (scanner == null) {
            if (this.internalScanner != null) {
                scanner = this.internalScanner;
            } else {
                throw new IllegalArgumentException("No Scanner defined");
            }
        }
        String line = null;
        int linesCount = 0;
        try {
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                if (linesCount == 0 && line == null) {
                    throw new IOException("Could not parse Stockholm file, BufferedReader returns null!");
                }
                if (line == null || line.trim().length() == 0) continue;
                if (line.startsWith("#=G")) {
                    String value;
                    String featureName;
                    String seqName;
                    String featureName2;
                    if (line.startsWith(GENERIC_PER_FILE_ANNOTATION, 2)) {
                        int firstSpaceIndex = line.indexOf(32, 5);
                        featureName2 = line.substring(5, firstSpaceIndex);
                        String value2 = line.substring(firstSpaceIndex).trim();
                        this.handleFileAnnotation(featureName2, value2);
                    } else if (line.startsWith(GENERIC_PER_CONSENSUS_ANNOTATION, 2)) {
                        int firstSpaceIndex = line.indexOf(32, 5);
                        featureName2 = line.substring(5, firstSpaceIndex);
                        String value3 = line.substring(firstSpaceIndex).trim();
                        this.handleConsensusAnnotation(featureName2, value3);
                    } else if (line.startsWith(GENERIC_PER_SEQUENCE_ANNOTATION, 2)) {
                        int index1 = line.indexOf(32, 5);
                        seqName = line.substring(5, index1);
                        while (line.charAt(++index1) <= ' ') {
                        }
                        int index2 = line.indexOf(32, index1);
                        featureName = line.substring(index1, index2);
                        value = line.substring(index2).trim();
                        this.handleSequenceAnnotation(seqName, featureName, value);
                    } else if (line.startsWith(GENERIC_PER_RESIDUE_ANNOTATION, 2)) {
                        int index1 = line.indexOf(32, 5);
                        seqName = line.substring(5, index1);
                        while (line.charAt(++index1) == ' ') {
                        }
                        int index2 = line.indexOf(32, index1);
                        featureName = line.substring(index1, index2);
                        value = line.substring(index2).trim();
                        this.handleResidueAnnotation(seqName, featureName, value);
                    }
                } else if (line.startsWith("# STOCKHOLM")) {
                    String[] header = line.split("\\s+");
                    this.stockholmStructure = new StockholmStructure();
                    this.stockholmStructure.getFileAnnotation().setFormat(header[1]);
                    this.stockholmStructure.getFileAnnotation().setVersion(header[2]);
                } else {
                    if (line.trim().equals("//")) break;
                    this.handleSequenceLine(line);
                }
                ++linesCount;
            }
        }
        catch (IOException e) {
            logger.error("IOException: ", (Throwable)e);
            throw new IOException("Error parsing Stockholm file");
        }
        StockholmStructure structure = this.stockholmStructure;
        this.stockholmStructure = null;
        if (structure != null) {
            int length = -1;
            Map<String, StringBuffer> sequences = structure.getSequences();
            for (String sequencename : sequences.keySet()) {
                StringBuffer sequence = sequences.get(sequencename);
                if (length == -1) {
                    length = sequence.length();
                    continue;
                }
                if (length == sequence.length()) continue;
                throw new RuntimeException("Sequences have different lengths");
            }
        }
        return structure;
    }

    private void handleSequenceLine(String line) {
        String[] lineContent = line.split("\\s+");
        if (lineContent.length != 2) {
            throw new ParserException("Could not split sequence line into sequence name and sequence:\n" + line);
        }
        this.stockholmStructure.appendToSequence(lineContent[0], lineContent[1]);
    }

    private void handleFileAnnotation(String featureName, String value) {
        if (featureName.equals("AC")) {
            this.stockholmStructure.getFileAnnotation().setGFAccessionNumber(value);
        } else if (featureName.equals(GF_IDENTIFICATION)) {
            this.stockholmStructure.getFileAnnotation().setGFIdentification(value);
        } else if (featureName.equals("DR")) {
            this.stockholmStructure.getFileAnnotation().addDBReference(value);
        } else if (featureName.equals("DE")) {
            this.stockholmStructure.getFileAnnotation().setGFDefinition(value);
        } else if (featureName.equals(GF_AUTHOR)) {
            this.stockholmStructure.getFileAnnotation().setGFAuthors(value);
        } else if (featureName.equals(GF_ALIGNMENT_METHOD)) {
            this.stockholmStructure.getFileAnnotation().setAlignmentMethod(value);
        } else if (featureName.equals(GF_BUILD_METHOD)) {
            this.stockholmStructure.getFileAnnotation().addGFBuildMethod(value);
        } else if (featureName.equals(GF_SEARCH_METHOD)) {
            this.stockholmStructure.getFileAnnotation().setGFSearchMethod(value);
        } else if (featureName.equals(GF_SOURCE_SEED)) {
            this.stockholmStructure.getFileAnnotation().setGFSourceSeed(value);
        } else if (featureName.equals("SS")) {
            this.stockholmStructure.getFileAnnotation().setGFSourceStructure(value);
        } else if (featureName.equals(GF_GATHERING_THRESHOLD)) {
            this.stockholmStructure.getFileAnnotation().setGFGatheringThreshs(value);
        } else if (featureName.equals(GF_TRUSTED_CUTOFF)) {
            this.stockholmStructure.getFileAnnotation().setGFTrustedCutoffs(value);
        } else if (featureName.equals(GF_NOISE_CUTOFF)) {
            this.stockholmStructure.getFileAnnotation().setGFNoiseCutoffs(value);
        } else if (featureName.equals(GF_TYPE_FIELD)) {
            this.stockholmStructure.getFileAnnotation().setGFTypeField(value);
        } else if (featureName.equals(GF_PREVIOUS_IDS)) {
            this.stockholmStructure.getFileAnnotation().setGFPreviousIDs(value);
        } else if (featureName.equals(GF_SEQUENCE)) {
            this.stockholmStructure.getFileAnnotation().setGFNumSequences(value);
        } else if (featureName.equals(GF_DB_COMMENT)) {
            this.stockholmStructure.getFileAnnotation().setGFDBComment(value);
        } else if (featureName.equals(GF_REFERENCE_COMMENT)) {
            this.stockholmStructure.getFileAnnotation().setGFRefComment(value);
        } else if (featureName.equals(GF_REFERENCE_NUMBER)) {
            StockholmFileAnnotation.StockholmFileAnnotationReference reference = new StockholmFileAnnotation.StockholmFileAnnotationReference();
            this.stockholmStructure.getFileAnnotation().getReferences().add(reference);
        } else if (featureName.equals(GF_REFERENCE_MEDLINE)) {
            this.stockholmStructure.getFileAnnotation().getReferences().lastElement().setRefMedline(value);
        } else if (featureName.equals(GF_REFERENCE_TITLE)) {
            this.stockholmStructure.getFileAnnotation().getReferences().lastElement().addToRefTitle(value);
        } else if (featureName.equals(GF_REFERENCE_AUTHOR)) {
            this.stockholmStructure.getFileAnnotation().getReferences().lastElement().addToRefAuthor(value);
        } else if (featureName.equals(GF_REFERENCE_LOCALTION)) {
            this.stockholmStructure.getFileAnnotation().getReferences().lastElement().setRefLocation(value);
        } else if (featureName.equals(GF_KEYWORDS)) {
            this.stockholmStructure.getFileAnnotation().setGFKeywords(value);
        } else if (featureName.equals(GF_COMMENT)) {
            this.stockholmStructure.getFileAnnotation().addToGFComment(value);
        } else if (featureName.equals(GF_PFAM_ACCESSION)) {
            this.stockholmStructure.getFileAnnotation().setGFPfamAccession(value);
        } else if (featureName.equals(GF_LOCATION)) {
            this.stockholmStructure.getFileAnnotation().setGFLocation(value);
        } else if (featureName.equals(GF_WIKIPEDIA_LINK)) {
            this.stockholmStructure.getFileAnnotation().setGFWikipediaLink(value);
        } else if (featureName.equals(GF_CLAN)) {
            this.stockholmStructure.getFileAnnotation().setGFClan(value);
        } else if (featureName.equals(GF_MEMBERSHIP)) {
            this.stockholmStructure.getFileAnnotation().setGFMembership(value);
        } else if (featureName.equals(GF_NEW_HAMPSHIRE)) {
            this.stockholmStructure.getFileAnnotation().addGFNewHampshire(value);
        } else if (featureName.equals(GF_TREE_ID)) {
            this.stockholmStructure.getFileAnnotation().addGFTreeID(value);
        } else if (featureName.equals(GF_FALSE_DISCOVERY_RATE)) {
            this.stockholmStructure.getFileAnnotation().addGFFalseDiscoveryRate(value);
        } else {
            logger.warn("Unknown File Feature [{}].\nPlease contact the Biojava team.", (Object)featureName);
        }
    }

    private void handleConsensusAnnotation(String featureName, String value) {
        if (featureName.equals(GC_SECONDARY_STRUCTURE)) {
            this.stockholmStructure.getConsAnnotation().setSecondaryStructure(value);
        } else if (featureName.equals(GC_SEQUENSE_CONSENSUS)) {
            this.stockholmStructure.getConsAnnotation().setSequenceConsensus(value);
        } else if (featureName.equals(GC_SURFACE_ACCESSIBILITY)) {
            this.stockholmStructure.getConsAnnotation().setSurfaceAccessibility(value);
        } else if (featureName.equals(GC_TRANS_MEMBRANE)) {
            this.stockholmStructure.getConsAnnotation().setTransMembrane(value);
        } else if (featureName.equals(GC_POSTERIOR_PROBABILITY)) {
            this.stockholmStructure.getConsAnnotation().setPosteriorProbability(value);
        } else if (featureName.equals(GC_LIGAND_BINDING)) {
            this.stockholmStructure.getConsAnnotation().setLigandBinding(value);
        } else if (featureName.equals(GC_ACTIVE_SITE)) {
            this.stockholmStructure.getConsAnnotation().setActiveSite(value);
        } else if (featureName.equals(GC_AS_PFAM_PREDICTED)) {
            this.stockholmStructure.getConsAnnotation().setAsPFamPredicted(value);
        } else if (featureName.equals(GC_AS_SWISSPROT)) {
            this.stockholmStructure.getConsAnnotation().setAsSwissProt(value);
        } else if (featureName.equals(GC_INTRON)) {
            this.stockholmStructure.getConsAnnotation().setIntron(value);
        } else if (featureName.equals(GC_REFERENCE_ANNOTATION)) {
            this.stockholmStructure.getConsAnnotation().setReferenceAnnotation(value);
        } else if (featureName.equals(GC_MODEL_MASK)) {
            this.stockholmStructure.getConsAnnotation().setModelMask(value);
        } else {
            logger.warn("Unknown Consensus Feature [{}].\nPlease contact the Biojava team.", (Object)featureName);
        }
    }

    private void handleSequenceAnnotation(String seqName, String featureName, String value) {
        if (featureName.equals("AC")) {
            this.stockholmStructure.addGSAccessionNumber(seqName, value);
        } else if (featureName.equals("DE")) {
            this.stockholmStructure.addGSDescription(seqName, value);
        } else if (featureName.equals("DR")) {
            this.stockholmStructure.addGSdbReference(seqName, value);
        } else if (featureName.equals(GS_ORGANISM_SPECIES)) {
            this.stockholmStructure.addGSOrganismSpecies(seqName, value);
        } else if (featureName.equals(GS_ORGANISM_CLASSIFICATION)) {
            this.stockholmStructure.addGSOrganismClassification(seqName, value);
        } else if (featureName.equals(GS_LOOK)) {
            this.stockholmStructure.addGSLook(seqName, value);
        } else {
            logger.warn("Unknown Sequence Feature [{}].\nPlease contact the Biojava team.", (Object)featureName);
        }
    }

    private void handleResidueAnnotation(String seqName, String featureName, String value) {
        if (featureName.equals(GR_SURFACE_ACCESSIBILITY)) {
            this.stockholmStructure.addSurfaceAccessibility(seqName, value);
        } else if (featureName.equals(GR_TRANS_MEMBRANE)) {
            this.stockholmStructure.addTransMembrane(seqName, value);
        } else if (featureName.equals(GR_POSTERIOR_PROBABILITY)) {
            this.stockholmStructure.addPosteriorProbability(seqName, value);
        } else if (featureName.equals(GR_LIGAND_BINDING)) {
            this.stockholmStructure.addLigandBinding(seqName, value);
        } else if (featureName.equals(GR_ACTIVE_SITE)) {
            this.stockholmStructure.addActiveSite(seqName, value);
        } else if (featureName.equals(GR_AS_PFAM_PREDICTED)) {
            this.stockholmStructure.addASPFamPredicted(seqName, value);
        } else if (featureName.equals(GR_AS_SWISSPROT)) {
            this.stockholmStructure.addASSwissProt(seqName, value);
        } else if (featureName.equals(GR_INTRON)) {
            this.stockholmStructure.addIntron(seqName, value);
        } else if (featureName.equals("SS")) {
            this.stockholmStructure.addSecondaryStructure(seqName, value);
        } else {
            logger.warn("Unknown Residue Feature [{}].\nPlease contact the Biojava team.", (Object)featureName);
        }
    }
}

