/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.sequencing.io.fastq;

import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import org.biojava.nbio.sequencing.io.fastq.ParseListener;

final class FastqParser {
    FastqParser() {
    }

    static void parse(Readable readable, ParseListener listener) throws IOException {
        if (readable == null) {
            throw new IllegalArgumentException("readable must not be null");
        }
        FastqParserLineProcessor lineProcessor = new FastqParserLineProcessor(listener);
        CharStreams.readLines((Readable)readable, (LineProcessor)lineProcessor);
        if (lineProcessor.getState() == State.COMPLETE) {
            listener.complete();
            lineProcessor.setState(State.DESCRIPTION);
        }
        if (lineProcessor.getState() != State.DESCRIPTION) {
            throw new IOException("truncated sequence");
        }
    }

    private static enum State {
        DESCRIPTION,
        SEQUENCE,
        REPEAT_DESCRIPTION,
        QUALITY,
        COMPLETE;

    }

    private static final class FastqParserLineProcessor
    implements LineProcessor<Object> {
        private State state = State.DESCRIPTION;
        private int sequenceLength = 0;
        private int qualityLength = 0;
        private final ParseListener listener;

        private FastqParserLineProcessor(ParseListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener must not be null");
            }
            this.listener = listener;
        }

        private State getState() {
            return this.state;
        }

        private void setState(State state) {
            this.state = state;
        }

        public Object getResult() {
            return null;
        }

        public boolean processLine(String line) throws IOException {
            String sequence = null;
            String quality = null;
            switch (this.state) {
                case DESCRIPTION: {
                    if (line.startsWith("@")) {
                        this.listener.description(line.substring(1).trim());
                        this.state = State.SEQUENCE;
                        break;
                    }
                    throw new IOException("description must begin with a '@' character");
                }
                case SEQUENCE: {
                    sequence = line.trim();
                    this.listener.sequence(sequence);
                    this.sequenceLength = sequence.length();
                    this.state = State.REPEAT_DESCRIPTION;
                    break;
                }
                case REPEAT_DESCRIPTION: {
                    if (line.startsWith("+")) {
                        this.listener.repeatDescription(line.substring(1).trim());
                        this.state = State.QUALITY;
                        break;
                    }
                    sequence = line.trim();
                    this.listener.appendSequence(sequence);
                    this.sequenceLength += sequence.length();
                    break;
                }
                case QUALITY: {
                    quality = line.trim();
                    this.listener.quality(quality);
                    this.qualityLength = quality.length();
                    this.state = State.COMPLETE;
                    break;
                }
                case COMPLETE: {
                    if (this.sequenceLength == this.qualityLength) {
                        this.listener.complete();
                        if (line.startsWith("@")) {
                            this.listener.description(line.substring(1).trim());
                            this.state = State.SEQUENCE;
                            break;
                        }
                        throw new IOException("description must begin with a '@' character");
                    }
                    quality = line.trim();
                    this.listener.appendQuality(quality);
                    this.qualityLength += quality.length();
                    break;
                }
            }
            return true;
        }
    }
}

