/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.gui;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.MultiThreadedDBSearch;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.gui.AlignmentCalculationRunnable;
import org.biojava.nbio.structure.align.gui.AlignmentGui;
import org.biojava.nbio.structure.align.gui.DBResultTable;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.scop.ScopFactory;

public class AlignmentCalcDB
implements AlignmentCalculationRunnable {
    public static String SCOP_VERSION = "1.75";
    AtomicBoolean interrupted;
    String name1;
    Structure structure1;
    AlignmentGui parent;
    UserConfiguration config;
    String outFile;
    int nrCPUs;
    Boolean domainSplit;
    StructureAlignment customAlgorithm;
    MultiThreadedDBSearch job = null;

    public StructureAlignment getAlgorithm() {
        return this.customAlgorithm;
    }

    public void setAlgorithm(StructureAlignment algo) {
        this.customAlgorithm = algo;
    }

    public AlignmentCalcDB(AlignmentGui parent, Structure s1, String name1, UserConfiguration config, String outFile, Boolean domainSplit) {
        this.parent = parent;
        this.structure1 = s1;
        this.name1 = name1;
        this.config = config;
        this.interrupted = new AtomicBoolean(false);
        this.outFile = outFile;
        this.domainSplit = domainSplit;
        System.out.println("AlignmentCalcDB: Using SCOP version " + SCOP_VERSION);
        ScopFactory.setScopDatabase((String)SCOP_VERSION);
    }

    @Override
    public void run() {
        StructureAlignment algorithm = null;
        algorithm = this.parent != null ? this.parent.getStructureAlignment() : this.customAlgorithm;
        if (this.name1.startsWith("file:/")) {
            this.name1 = "CUSTOM";
        }
        this.job = new MultiThreadedDBSearch(this.name1, this.structure1, this.outFile, algorithm, this.nrCPUs, this.domainSplit.booleanValue());
        AtomCache cache = new AtomCache(this.config);
        System.out.println("using cache: " + cache.getPath());
        System.out.println("name1: " + this.name1);
        System.out.println("structure:" + this.structure1.getName());
        this.job.setAtomCache(cache);
        if (this.name1.equals("CUSTOM")) {
            this.job.setCustomFile1(this.parent.getDBSearch().getPDBUploadPanel().getFilePath1());
            this.job.setCustomChain1(this.parent.getDBSearch().getPDBUploadPanel().getChain1());
        }
        this.job.run();
        File resultList = this.job.getResultFile();
        if (this.parent != null) {
            this.parent.notifyCalcFinished();
            if (resultList != null) {
                DBResultTable table = new DBResultTable();
                table.show(resultList, this.config);
            }
        }
    }

    @Override
    public void interrupt() {
        this.interrupted.set(true);
        if (this.job != null) {
            this.job.interrupt();
        }
    }

    @Override
    public void cleanup() {
        this.parent.notifyCalcFinished();
        this.parent = null;
        this.structure1 = null;
        this.config = null;
        if (this.job != null) {
            this.job.cleanup();
        }
    }

    @Override
    public void setNrCPUs(int useNrCPUs) {
        this.nrCPUs = useNrCPUs;
    }

    public synchronized boolean isInterrupted() {
        return this.interrupted.get();
    }
}

