/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.StrucAligParameters;
import org.biojava.nbio.structure.align.StructurePairAligner;
import org.biojava.nbio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.nbio.structure.align.pairwise.FragmentPair;
import org.biojava.nbio.structure.gui.JMatrixPanel;
import org.biojava.nbio.structure.gui.util.color.ContinuousColorMapper;
import org.biojava.nbio.structure.gui.util.color.GradientMapper;
import org.biojava.nbio.structure.gui.util.color.GradientPanel;
import org.biojava.nbio.structure.gui.util.color.HSVColorSpace;
import org.biojava.nbio.structure.gui.util.color.LinearColorInterpolator;
import org.biojava.nbio.structure.gui.util.color.LogColorMapper;
import org.biojava.nbio.structure.gui.util.color.SqrtColorMapper;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.biojava.nbio.structure.jama.Matrix;

public class ScaleableMatrixPanel
extends JPanel
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = -8082261434322968652L;
    protected JMatrixPanel mPanel = new JMatrixPanel();
    protected JSlider slider;
    protected JScrollPane scroll;
    protected JComboBox coloring;
    protected Map<String, ContinuousColorMapper> gradients;
    protected static final int SLIDER_STEPS = 8;

    public static void main(String[] args) {
        PDBFileReader pdbr = new PDBFileReader();
        pdbr.setPath("/tmp/");
        String pdb1 = "1buz";
        String pdb2 = "1ali";
        StructurePairAligner sc = new StructurePairAligner();
        StrucAligParameters params = new StrucAligParameters();
        params.setMaxIter(1);
        sc.setParams(params);
        try {
            Structure s1 = pdbr.getStructureById(pdb1);
            Structure s2 = pdbr.getStructureById(pdb2);
            System.out.println("aligning " + pdb1 + " vs. " + pdb2);
            System.out.println(s1);
            System.out.println();
            System.out.println(s2);
            sc.align(s1, s2);
            ScaleableMatrixPanel smp = new ScaleableMatrixPanel();
            JFrame frame = new JFrame();
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JFrame f = (JFrame)e.getSource();
                    f.setVisible(false);
                    f.dispose();
                }
            });
            smp.setMatrix(sc.getDistMat());
            smp.setFragmentPairs(sc.getFragmentPairs());
            smp.setAlternativeAligs(sc.getAlignments());
            for (int i = 0; i < sc.getAlignments().length; ++i) {
                AlternativeAlignment aa = sc.getAlignments()[i];
                System.out.println(aa);
            }
            frame.getContentPane().add(smp);
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ScaleableMatrixPanel() {
        Box vBox = Box.createVerticalBox();
        Box gradientBox = Box.createHorizontalBox();
        vBox.add(gradientBox);
        gradientBox.add(new JLabel("Coloring:"));
        this.gradients = ScaleableMatrixPanel.createGradients();
        this.setCellColor(this.gradients.values().iterator().next());
        this.coloring = new JComboBox<String>(this.gradients.keySet().toArray(new String[0]));
        this.coloring.setRenderer(new GradientRenderer());
        this.coloring.addActionListener(this);
        this.coloring.setMaximumSize(new Dimension(1000, 30));
        gradientBox.add(this.coloring);
        int RES_MIN = 0;
        int RES_MAX = 64;
        int RES_INIT = 8;
        this.slider = new JSlider(0, RES_MIN, RES_MAX, RES_INIT);
        this.slider.setInverted(false);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(8);
        this.slider.setSnapToTicks(false);
        this.slider.setPaintLabels(false);
        this.slider.setPaintTrack(true);
        this.slider.addChangeListener(this);
        this.slider.setPreferredSize(new Dimension(100, this.slider.getPreferredSize().height));
        vBox.add(this.slider);
        this.scroll = new JScrollPane(this.mPanel);
        this.scroll.getHorizontalScrollBar().setUnitIncrement(60);
        this.scroll.getVerticalScrollBar().setUnitIncrement(60);
        this.scroll.getHorizontalScrollBar().setBlockIncrement(60);
        this.scroll.getVerticalScrollBar().setBlockIncrement(60);
        vBox.add(this.scroll);
        this.setPreferredSize(new Dimension(400, 400));
        this.add(vBox);
        this.mPanel.setLayout(new BoxLayout(this.mPanel, 1));
        this.setLayout(new BoxLayout(this, 1));
    }

    protected static Map<String, ContinuousColorMapper> createGradients() {
        TreeMap<String, ContinuousColorMapper> gradients = new TreeMap<String, ContinuousColorMapper>();
        int i = 0;
        ColorSpace hsv = HSVColorSpace.getHSVColorSpace();
        LinearColorInterpolator interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.INNER);
        GradientMapper gradient = new GradientMapper(Color.green, Color.black, hsv);
        gradient.put(-50.0, new Color(hsv, new float[]{0.0f, 0.9f, 0.0f}, 1.0f));
        gradient.put(10.0, new Color(hsv, new float[]{1.0f, 0.9f, 1.0f}, 1.0f));
        gradient.setInterpolator(interp);
        gradients.put(++i + ". -50 to 10", gradient);
        interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.INNER);
        gradient = new GradientMapper(Color.green, Color.black, hsv);
        gradient.put(0.0, new Color(hsv, new float[]{1.0f, 0.9f, 1.0f}, 1.0f));
        gradient.put(10.0, new Color(hsv, new float[]{0.0f, 0.9f, 0.0f}, 1.0f));
        gradient.setInterpolator(interp);
        gradients.put(++i + ". Default", gradient);
        interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.INNER);
        gradient = new GradientMapper(Color.green, Color.black, hsv);
        gradient.put(0.0, new Color(hsv, new float[]{1.0f, 0.9f, 1.0f}, 1.0f));
        gradient.put(5.0, new Color(hsv, new float[]{0.0f, 0.9f, 0.0f}, 1.0f));
        gradient.setInterpolator(interp);
        gradients.put(++i + ". Sensitive", gradient);
        interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.INNER);
        gradient = new GradientMapper(Color.green, Color.black, hsv);
        gradient.put(0.0, new Color(hsv, new float[]{1.0f, 0.9f, 1.0f}, 1.0f));
        gradient.put(1.0, new Color(hsv, new float[]{0.2f, 0.9f, 1.0f}, 1.0f));
        gradient.put(1.000001, Color.white);
        gradient.put(5.0, Color.black);
        gradient.setInterpolator(interp);
        gradients.put(++i + ". Emphasize low", gradient);
        interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.INNER);
        gradient = new GradientMapper(Color.green, Color.black, hsv);
        gradient.put(0.0, new Color(hsv, new float[]{0.0f, 0.9f, 0.0f}, 1.0f));
        gradient.put(100.0, new Color(hsv, new float[]{1.0f, 0.9f, 1.0f}, 1.0f));
        gradient.setInterpolator(interp);
        gradients.put(++i + ". 0 to 100", gradient);
        interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.INNER);
        gradient = new GradientMapper(Color.red, Color.black, hsv);
        gradient.put(0.0, new Color(hsv, new float[]{1.0f, 0.9f, 1.0f}, 1.0f));
        gradient.put(10.0, new Color(hsv, new float[]{0.0f, 0.9f, 0.0f}, 1.0f));
        gradient.setInterpolator(interp);
        LogColorMapper logGradient = new LogColorMapper(gradient, 2);
        gradients.put(++i + ". Logorithmic", logGradient);
        interp = new LinearColorInterpolator(hsv);
        interp.setInterpolationDirection(0, LinearColorInterpolator.InterpolationDirection.INNER);
        gradient = new GradientMapper(Color.red, Color.black, hsv);
        gradient.put(0.0, new Color(hsv, new float[]{1.0f, 0.9f, 1.0f}, 1.0f));
        gradient.put(4.0, new Color(hsv, new float[]{0.0f, 0.9f, 0.0f}, 1.0f));
        gradient.setInterpolator(interp);
        SqrtColorMapper sqrtGradient = new SqrtColorMapper(gradient);
        gradients.put(++i + ". Square Root", sqrtGradient);
        GradientMapper black = new GradientMapper(Color.BLACK, Color.BLACK);
        gradients.put(++i + ". Black", black);
        return gradients;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (source.getValueIsAdjusting()) {
            // empty if block
        }
        this.mPanel.setScale((float)source.getValue() / 8.0f);
        this.scroll.repaint();
        this.scroll.updateUI();
    }

    public Matrix getMatrix() {
        return this.mPanel.getMatrix();
    }

    public void setMatrix(Matrix matrix) {
        this.mPanel.setMatrix(matrix);
    }

    public JMatrixPanel getMatrixPanel() {
        return this.mPanel;
    }

    public FragmentPair[] getFragmentPairs() {
        return this.mPanel.getFragmentPairs();
    }

    public void setFragmentPairs(FragmentPair[] pairs) {
        this.mPanel.setFragmentPairs(pairs);
    }

    public AlternativeAlignment[] getAlternativeAligs() {
        return this.mPanel.getAlternativeAligs();
    }

    public void setAlternativeAligs(AlternativeAlignment[] aligs) {
        this.mPanel.setAlternativeAligs(aligs);
    }

    public int getSelectedAlignmentPos() {
        return this.mPanel.getSelectedAlignmentPos();
    }

    public void setSelectedAlignmentPos(int selectedAlignmentPos) {
        this.mPanel.setSelectedAlignmentPos(selectedAlignmentPos);
    }

    public ContinuousColorMapper getCellColor() {
        return this.mPanel.getCellColor();
    }

    public void setCellColor(ContinuousColorMapper cellColor) {
        this.mPanel.setCellColor(cellColor);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        String gradientName = (String)cb.getSelectedItem();
        ContinuousColorMapper gradient = this.gradients.get(gradientName);
        assert (gradient != null);
        this.setCellColor(gradient);
        this.repaint();
    }

    protected class GradientRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = -2000575579184232365L;
        private int min;
        private int max;
        JLabel title;
        JPanel gradientContainer;

        public GradientRenderer() {
            this.setPreferredSize(new Dimension(100, 25));
            this.setLayout(new BorderLayout());
            this.min = -1;
            this.max = 10;
            JPanel gradientBounds = new JPanel();
            gradientBounds.setLayout(new BorderLayout());
            gradientBounds.add((Component)new JLabel(Integer.toString(this.min)), "West");
            this.gradientContainer = new JPanel();
            this.gradientContainer.setLayout(new BorderLayout());
            this.gradientContainer.setOpaque(false);
            this.gradientContainer.add((Component)new JLabel("<No gradient>"), "Center");
            gradientBounds.add((Component)this.gradientContainer, "Center");
            gradientBounds.setOpaque(false);
            gradientBounds.add((Component)new JLabel(Integer.toString(this.max)), "East");
            this.add((Component)gradientBounds, "East");
            this.title = new JLabel("No gradient");
            this.title.setHorizontalAlignment(0);
            this.title.setVerticalAlignment(0);
            this.add((Component)this.title, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String gradientLabel = (String)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            GradientPanel gradPanel = new GradientPanel(ScaleableMatrixPanel.this.gradients.get(gradientLabel), this.min, this.max);
            gradPanel.setPreferredSize(new Dimension(100, 20));
            this.gradientContainer.removeAll();
            this.gradientContainer.add((Component)gradPanel, "Center");
            this.title.setText(gradientLabel);
            this.validate();
            return this;
        }
    }
}

