/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomPositionMap;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.ResidueRangeAndLength;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIO;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.client.StructureName;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.cath.CathDatabase;
import org.biojava.nbio.structure.cath.CathDomain;
import org.biojava.nbio.structure.cath.CathFactory;
import org.biojava.nbio.structure.domain.PDPProvider;
import org.biojava.nbio.structure.domain.RemotePDPProvider;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.LocalPDBDirectory;
import org.biojava.nbio.structure.io.MMCIFFileReader;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.biojava.nbio.structure.io.util.FileDownloadUtils;
import org.biojava.nbio.structure.quaternary.io.BioUnitDataProviderFactory;
import org.biojava.nbio.structure.quaternary.io.MmCifBiolAssemblyProvider;
import org.biojava.nbio.structure.quaternary.io.PDBBioUnitDataProvider;
import org.biojava.nbio.structure.scop.CachedRemoteScopInstallation;
import org.biojava.nbio.structure.scop.ScopDatabase;
import org.biojava.nbio.structure.scop.ScopDescription;
import org.biojava.nbio.structure.scop.ScopDomain;
import org.biojava.nbio.structure.scop.ScopFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomCache {
    private static final Logger logger = LoggerFactory.getLogger(AtomCache.class);
    public static final String BIOL_ASSEMBLY_IDENTIFIER = "BIO:";
    public static final String CHAIN_NR_SYMBOL = ":";
    public static final String CHAIN_SPLIT_SYMBOL = ".";
    public static final String PDP_DOMAIN_IDENTIFIER = "PDP:";
    public static final String UNDERSCORE = "_";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected FileParsingParameters params;
    protected PDPProvider pdpprovider;
    private LocalPDBDirectory.FetchBehavior fetchBehavior;
    private LocalPDBDirectory.ObsoleteBehavior obsoleteBehavior;
    private String cachePath;
    private Collection<String> currentlyLoading = Collections.synchronizedCollection(new TreeSet());
    private String path;
    private boolean useMmCif;

    public AtomCache() {
        this(new UserConfiguration());
    }

    public AtomCache(String pdbFilePath) {
        this(pdbFilePath, pdbFilePath);
    }

    public AtomCache(String pdbFilePath, String cachePath) {
        logger.debug("Initialising AtomCache with pdbFilePath={}, cachePath={}", (Object)pdbFilePath, (Object)cachePath);
        if (!pdbFilePath.endsWith(FILE_SEPARATOR)) {
            pdbFilePath = pdbFilePath + FILE_SEPARATOR;
        }
        System.setProperty("biojava.cache.files", "true");
        this.setPath(pdbFilePath);
        this.cachePath = cachePath;
        this.fetchBehavior = LocalPDBDirectory.FetchBehavior.DEFAULT;
        this.obsoleteBehavior = LocalPDBDirectory.ObsoleteBehavior.DEFAULT;
        this.currentlyLoading.clear();
        this.params = new FileParsingParameters();
        this.setUseMmCif(true);
    }

    @Deprecated
    public AtomCache(String pdbFilePath, boolean isSplit) {
        this(pdbFilePath);
    }

    @Deprecated
    public AtomCache(String pdbFilePath, String cachePath, boolean isSplit) {
        this(pdbFilePath, cachePath);
    }

    public AtomCache(UserConfiguration config) {
        this(config.getPdbFilePath(), config.getCacheFilePath());
        this.fetchBehavior = config.getFetchBehavior();
        this.obsoleteBehavior = config.getObsoleteBehavior();
        this.useMmCif = config.getFileFormat().equals("mmCif");
    }

    public Atom[] getAtoms(String name) throws IOException, StructureException {
        return this.getAtoms(new StructureName(name));
    }

    public Atom[] getAtoms(StructureIdentifier name) throws IOException, StructureException {
        Atom[] atoms = null;
        Structure s = this.getStructure(name);
        atoms = StructureTools.getAtomCAArray(s);
        return atoms;
    }

    public Atom[] getRepresentativeAtoms(String name) throws IOException, StructureException {
        return this.getRepresentativeAtoms(new StructureName(name));
    }

    public Atom[] getRepresentativeAtoms(StructureIdentifier name) throws IOException, StructureException {
        Atom[] atoms = null;
        Structure s = this.getStructure(name);
        atoms = StructureTools.getRepresentativeAtomArray(s);
        return atoms;
    }

    public Structure getBiologicalAssembly(String pdbId, int bioAssemblyId, boolean bioAssemblyFallback) throws StructureException, IOException {
        if (bioAssemblyId < 0) {
            throw new StructureException("bioAssemblyID must be nonnegative: " + pdbId + " bioAssemblyId " + bioAssemblyId);
        }
        Structure s = StructureIO.getBiologicalAssembly(pdbId, bioAssemblyId, this);
        if (s == null && bioAssemblyFallback) {
            return StructureIO.getBiologicalAssembly(pdbId, 0, this);
        }
        return s;
    }

    public Structure getBiologicalAssembly(String pdbId) throws StructureException, IOException {
        int bioAssemblyId = 1;
        return this.getBiologicalAssembly(pdbId, bioAssemblyId);
    }

    @Deprecated
    public Structure getBiologicalUnit(String pdbId) throws StructureException, IOException {
        return this.getBiologicalAssembly(pdbId);
    }

    public Structure getBiologicalAssembly(String pdbId, int bioAssemblyId) throws StructureException, IOException {
        boolean bioAssemblyFallback = true;
        return this.getBiologicalAssembly(pdbId, bioAssemblyId, bioAssemblyFallback);
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public FileParsingParameters getFileParsingParams() {
        return this.params;
    }

    public String getPath() {
        return this.path;
    }

    public PDPProvider getPdpprovider() {
        return this.pdpprovider;
    }

    public Structure getStructure(String name) throws IOException, StructureException {
        StructureName structureName = new StructureName(name);
        return this.getStructure(structureName);
    }

    public Structure getStructure(StructureIdentifier strucId) throws IOException, StructureException {
        Structure s = strucId.loadStructure(this);
        Structure r = strucId.reduce(s);
        r.setStructureIdentifier(strucId);
        return r;
    }

    public Structure getStructureForDomain(ScopDomain domain) throws IOException, StructureException {
        return this.getStructureForDomain(domain, ScopFactory.getSCOP());
    }

    public Structure getStructureForDomain(ScopDomain domain, ScopDatabase scopDatabase) throws IOException, StructureException {
        return this.getStructureForDomain(domain, scopDatabase, false);
    }

    public Structure getStructureForDomain(ScopDomain domain, ScopDatabase scopDatabase, boolean strictLigandHandling) throws IOException, StructureException {
        int sf;
        ScopDescription description;
        String pdbId = domain.getPdbId();
        Structure fullStructure = this.getStructureForPdbId(pdbId);
        Structure structure = domain.reduce(fullStructure);
        AtomPositionMap map = null;
        List<ResidueRangeAndLength> rrs = null;
        if (strictLigandHandling) {
            map = new AtomPositionMap(StructureTools.getAllAtomArray(fullStructure), AtomPositionMap.ANYTHING_MATCHER);
            rrs = ResidueRangeAndLength.parseMultiple(domain.getRanges(), map);
        }
        for (Chain chain : fullStructure.getChains()) {
            if (!structure.hasChain(chain.getChainID())) continue;
            Chain newChain = structure.getChainByPDB(chain.getChainID());
            List<Group> ligands = StructureTools.filterLigands(chain.getAtomGroups());
            for (Group group : ligands) {
                boolean shouldContain = true;
                if (strictLigandHandling) {
                    shouldContain = false;
                    for (ResidueRange residueRange : rrs) {
                        if (!residueRange.contains(group.getResidueNumber(), map)) continue;
                        shouldContain = true;
                    }
                }
                boolean alreadyContains = newChain.getAtomGroups().contains(group);
                if (!shouldContain || alreadyContains) continue;
                newChain.addGroup(group);
            }
        }
        StringBuilder header = new StringBuilder();
        header.append(domain.getClassificationId());
        if (scopDatabase != null && (description = scopDatabase.getScopDescriptionBySunid(sf = domain.getSuperfamilyId())) != null) {
            header.append(" | ");
            header.append(description.getDescription());
        }
        structure.getPDBHeader().setDescription(header.toString());
        return structure;
    }

    public Structure getStructureForDomain(String scopId) throws IOException, StructureException {
        return this.getStructureForDomain(scopId, ScopFactory.getSCOP());
    }

    public Structure getStructureForDomain(String scopId, ScopDatabase scopDatabase) throws IOException, StructureException {
        ScopDomain domain = scopDatabase.getDomainByScopID(scopId);
        return this.getStructureForDomain(domain, scopDatabase);
    }

    @Deprecated
    public boolean isAutoFetch() {
        return this.fetchBehavior != LocalPDBDirectory.FetchBehavior.LOCAL_ONLY;
    }

    @Deprecated
    public boolean isFetchCurrent() {
        return this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_CURRENT;
    }

    @Deprecated
    public boolean isFetchFileEvenIfObsolete() {
        return this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_OBSOLETE;
    }

    @Deprecated
    public boolean isStrictSCOP() {
        return false;
    }

    public void notifyShutdown() {
        ScopDatabase scopInstallation;
        if (this.pdpprovider != null && this.pdpprovider instanceof RemotePDPProvider) {
            RemotePDPProvider remotePDP = (RemotePDPProvider)this.pdpprovider;
            remotePDP.flushCache();
        }
        if ((scopInstallation = ScopFactory.getSCOP()) != null && scopInstallation instanceof CachedRemoteScopInstallation) {
            CachedRemoteScopInstallation cacheScop = (CachedRemoteScopInstallation)scopInstallation;
            cacheScop.flushCache();
        }
    }

    @Deprecated
    public void setAutoFetch(boolean autoFetch) {
        if (autoFetch) {
            this.setFetchBehavior(LocalPDBDirectory.FetchBehavior.DEFAULT);
        } else {
            this.setFetchBehavior(LocalPDBDirectory.FetchBehavior.LOCAL_ONLY);
        }
    }

    public void setCachePath(String cachePath) {
        this.cachePath = cachePath;
    }

    @Deprecated
    public void setFetchCurrent(boolean fetchNewestCurrent) {
        if (fetchNewestCurrent) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.FETCH_CURRENT);
        } else if (this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_CURRENT) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.DEFAULT);
        }
    }

    @Deprecated
    public void setFetchFileEvenIfObsolete(boolean fetchFileEvenIfObsolete) {
        if (fetchFileEvenIfObsolete) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.FETCH_OBSOLETE);
        } else if (this.getObsoleteBehavior() == LocalPDBDirectory.ObsoleteBehavior.FETCH_OBSOLETE) {
            this.setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior.DEFAULT);
        }
    }

    public void setFileParsingParams(FileParsingParameters params) {
        this.params = params;
    }

    public void setObsoleteBehavior(LocalPDBDirectory.ObsoleteBehavior behavior) {
        this.obsoleteBehavior = behavior;
    }

    public LocalPDBDirectory.ObsoleteBehavior getObsoleteBehavior() {
        return this.obsoleteBehavior;
    }

    public LocalPDBDirectory.FetchBehavior getFetchBehavior() {
        return this.fetchBehavior;
    }

    public void setFetchBehavior(LocalPDBDirectory.FetchBehavior fetchBehavior) {
        this.fetchBehavior = fetchBehavior;
    }

    public void setPath(String path) {
        this.path = FileDownloadUtils.expandUserHome(path);
    }

    public void setPdpprovider(PDPProvider pdpprovider) {
        this.pdpprovider = pdpprovider;
    }

    @Deprecated
    public void setStrictSCOP(boolean ignored) {
    }

    public boolean isUseMmCif() {
        return this.useMmCif;
    }

    public void setUseMmCif(boolean useMmCif) {
        this.useMmCif = useMmCif;
        if (useMmCif) {
            BioUnitDataProviderFactory.setBioUnitDataProvider(MmCifBiolAssemblyProvider.class);
        } else {
            BioUnitDataProviderFactory.setBioUnitDataProvider(PDBBioUnitDataProvider.class);
        }
    }

    private boolean checkLoading(String name) {
        return this.currentlyLoading.contains(name);
    }

    public Structure getStructureForCathDomain(StructureName structureName) throws IOException, StructureException {
        return this.getStructureForCathDomain(structureName, CathFactory.getCathDatabase());
    }

    public Structure getStructureForCathDomain(StructureName structureName, CathDatabase cathInstall) throws IOException, StructureException {
        CathDomain cathDomain = cathInstall.getDomainByCathId(structureName.getIdentifier());
        Structure s = this.getStructureForPdbId(cathDomain.getIdentifier());
        Structure n = cathDomain.reduce(s);
        Chain newChain = n.getChainByPDB(structureName.getChainId());
        Chain origChain = s.getChainByPDB(structureName.getChainId());
        List<Group> ligands = origChain.getAtomLigands();
        for (Group g : ligands) {
            if (newChain.getAtomGroups().contains(g)) continue;
            newChain.addGroup(g);
        }
        return n;
    }

    protected void flagLoading(String name) {
        if (!this.currentlyLoading.contains(name)) {
            this.currentlyLoading.add(name);
        }
    }

    protected void flagLoadingFinished(String name) {
        this.currentlyLoading.remove(name);
    }

    public Structure getStructureForPdbId(String pdbId) throws IOException, StructureException {
        if (pdbId == null) {
            return null;
        }
        if (pdbId.length() != 4) {
            throw new StructureException("Unrecognized PDB ID: " + pdbId);
        }
        while (this.checkLoading(pdbId)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
            }
        }
        Structure s = this.useMmCif ? this.loadStructureFromCifByPdbId(pdbId) : this.loadStructureFromPdbByPdbId(pdbId);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Structure loadStructureFromCifByPdbId(String pdbId) throws IOException, StructureException {
        Structure s;
        this.flagLoading(pdbId);
        try {
            MMCIFFileReader reader = new MMCIFFileReader(this.path);
            reader.setFetchBehavior(this.fetchBehavior);
            reader.setObsoleteBehavior(this.obsoleteBehavior);
            reader.setFileParsingParameters(this.params);
            s = reader.getStructureById(pdbId.toLowerCase());
        }
        finally {
            this.flagLoadingFinished(pdbId);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Structure loadStructureFromPdbByPdbId(String pdbId) throws IOException, StructureException {
        Structure s;
        this.flagLoading(pdbId);
        try {
            PDBFileReader reader = new PDBFileReader(this.path);
            reader.setFetchBehavior(this.fetchBehavior);
            reader.setObsoleteBehavior(this.obsoleteBehavior);
            reader.setFileParsingParameters(this.params);
            s = reader.getStructureById(pdbId.toLowerCase());
        }
        finally {
            this.flagLoadingFinished(pdbId);
        }
        return s;
    }
}

