/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignmentFactory;
import org.biojava.nbio.structure.align.ce.CeParameters;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.seq.SmithWaterman3Daligner;
import org.biojava.nbio.structure.symmetry.core.PairwiseAlignment;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.UniqueSequenceList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceAlignmentCluster
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(SequenceAlignmentCluster.class);
    private QuatSymmetryParameters parameters = null;
    private List<UniqueSequenceList> uniqueSequenceList = new ArrayList<UniqueSequenceList>();
    private List<Atom[]> alignedCAlphaAtoms = null;
    private int alignmentLength = 0;
    private double minSequenceIdentity = 1.0;
    private double maxSequenceIdentity = 0.0;
    private boolean modified = true;

    public SequenceAlignmentCluster(QuatSymmetryParameters parameters) {
        this.parameters = parameters;
    }

    public boolean isPseudoStoichiometric() {
        return this.minSequenceIdentity < this.parameters.getSequencePseudoSymmetryThreshold();
    }

    public double getMinSequenceIdentity() {
        if (!this.isPseudoStoichiometric()) {
            return 1.0;
        }
        return this.minSequenceIdentity;
    }

    public void setMinSequenceIdentity(double minSequenceIdentity) {
        this.minSequenceIdentity = minSequenceIdentity;
    }

    public double getMaxSequenceIdentity() {
        if (!this.isPseudoStoichiometric()) {
            return 1.0;
        }
        return this.maxSequenceIdentity;
    }

    public void setMaxSequenceIdentity(double maxSequenceIdentity) {
        this.maxSequenceIdentity = maxSequenceIdentity;
    }

    public void addUniqueSequenceList(UniqueSequenceList sequenceList) {
        this.uniqueSequenceList.add(sequenceList);
        this.modified = true;
    }

    public int getSequenceCount() {
        return this.uniqueSequenceList.size();
    }

    public int getSequenceAlignmentLength() {
        this.run();
        return this.alignmentLength;
    }

    public List<UniqueSequenceList> getUniqueSequenceList() {
        return this.uniqueSequenceList;
    }

    public List<String> getChainIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (UniqueSequenceList list : this.uniqueSequenceList) {
            ids.add(list.getChainId());
        }
        return ids;
    }

    public List<Integer> getModelNumbers() {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (UniqueSequenceList list : this.uniqueSequenceList) {
            numbers.add(list.getModelNumber());
        }
        return numbers;
    }

    public List<Integer> getStructureIds() {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (UniqueSequenceList list : this.uniqueSequenceList) {
            numbers.add(list.getStructureId());
        }
        return numbers;
    }

    public List<Atom[]> getAlignedCalphaAtoms() {
        this.run();
        return this.alignedCAlphaAtoms;
    }

    public boolean identityMatch(Atom[] cAlphaAtoms, String chainId, int modelNumber, int structureId, String sequence) {
        UniqueSequenceList u = this.uniqueSequenceList.get(0);
        String refSequence = u.getSeqResSequence();
        boolean seqMatch = refSequence.equals(sequence);
        if (seqMatch) {
            ArrayList<Integer> alig1 = new ArrayList<Integer>();
            ArrayList<Integer> alig2 = new ArrayList<Integer>();
            Atom[] referenceAtoms = u.getCalphaAtoms();
            int inCommon = 0;
            try {
                inCommon = SequenceAlignmentCluster.alignIdenticalSequence(referenceAtoms, cAlphaAtoms, alig1, alig2);
            }
            catch (StructureException e) {
                logger.warn("Could not align identical sequences {}: {} and {}: {}. Chains won't be clustered together.", new Object[]{u.getChainId(), refSequence, chainId, sequence});
            }
            if (inCommon > 0) {
                UniqueSequenceList seqList = new UniqueSequenceList(cAlphaAtoms, chainId, modelNumber, structureId, sequence);
                seqList.setAlignment1(alig1);
                seqList.setAlignment2(alig2);
                this.addUniqueSequenceList(seqList);
                return true;
            }
        }
        return false;
    }

    public PairwiseAlignment getPairwiseAlignment(SequenceAlignmentCluster other) {
        Atom[] referenceAtoms2;
        PairwiseAlignment alignment = new PairwiseAlignment(this, other);
        Atom[] referenceAtoms1 = this.getUniqueSequenceList().get(0).getCalphaAtoms();
        double alignmentLengthFraction = (double)Math.min(referenceAtoms1.length, (referenceAtoms2 = other.getUniqueSequenceList().get(0).getCalphaAtoms()).length) / (double)Math.max(referenceAtoms1.length, referenceAtoms2.length);
        if (alignmentLengthFraction < this.parameters.getAlignmentFractionThreshold()) {
            return null;
        }
        AFPChain afp = SequenceAlignmentCluster.alignPairByStructure(referenceAtoms1, referenceAtoms2, this.parameters.isVerbose());
        if (afp == null) {
            return null;
        }
        if (!afp.isSignificantResult()) {
            return null;
        }
        int[][][] align = afp.getOptAln();
        if (align == null) {
            return null;
        }
        alignmentLengthFraction = (double)afp.getOptLength() / (double)Math.max(referenceAtoms1.length, referenceAtoms2.length);
        alignment.setAlignmentLengthFraction(alignmentLengthFraction);
        alignment.setRmsd(afp.getChainRmsd());
        alignment.setSequenceIdentity(afp.getIdentity());
        alignment.setAlignment(afp.getOptAln());
        return alignment;
    }

    public Object clone() {
        SequenceAlignmentCluster copy = null;
        try {
            copy = (SequenceAlignmentCluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error("CloneNotSupportedException caught", (Throwable)e);
        }
        copy.uniqueSequenceList = new ArrayList<UniqueSequenceList>();
        for (UniqueSequenceList seq : this.getUniqueSequenceList()) {
            copy.addUniqueSequenceList((UniqueSequenceList)seq.clone());
        }
        return copy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (UniqueSequenceList u : this.uniqueSequenceList) {
            builder.append(u.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    private void run() {
        if (this.modified) {
            this.alignedCAlphaAtoms = null;
            this.createAlignedCAlphaAtoms();
            this.modified = false;
        }
    }

    private static AFPChain alignPairBySequence(Atom[] ca1Seq, Atom[] ca2Seq) throws StructureException {
        SmithWaterman3Daligner aligner = new SmithWaterman3Daligner();
        return aligner.align(ca1Seq, ca2Seq);
    }

    private static AFPChain alignPairByStructure(Atom[] ca1Seq, Atom[] ca2Seq, boolean verbose) {
        CeParameters params = new CeParameters();
        AFPChain afp = null;
        try {
            StructureAlignment algorithm = StructureAlignmentFactory.getAlgorithm("jCE");
            afp = algorithm.align(ca1Seq, ca2Seq, params);
            if (verbose) {
                System.out.println(afp.toFatcat(ca1Seq, ca2Seq));
            }
        }
        catch (StructureException e) {
            logger.error("StructureException caught", (Throwable)e);
        }
        return afp;
    }

    private static int alignIdenticalSequence(Atom[] ca1Seq, Atom[] ca2Seq, List<Integer> align1, List<Integer> align2) throws StructureException {
        int n2;
        AFPChain afp = SequenceAlignmentCluster.alignPairBySequence(ca1Seq, ca2Seq);
        int[][][] align = afp.getOptAln();
        if (align == null) {
            return 0;
        }
        int len = afp.getOptLength();
        ArrayList<Integer> delta = new ArrayList<Integer>();
        HashSet<Integer> unique = new HashSet<Integer>();
        for (int i = 0; i < len; ++i) {
            Atom a2;
            String residueName2;
            Atom a1 = ca1Seq[align[0][0][i]];
            String residueName1 = a1.getGroup().getPDBName();
            if (!residueName1.equals(residueName2 = (a2 = ca2Seq[align[0][1][i]]).getGroup().getPDBName())) continue;
            int n1 = a1.getGroup().getResidueNumber().getSeqNum();
            n2 = a2.getGroup().getResidueNumber().getSeqNum();
            delta.add(n2 - n1);
            unique.add(n2 - n1);
        }
        int offset = 0;
        int frequency = 0;
        for (Integer i : unique) {
            int freq = Collections.frequency(delta, i);
            if (freq <= frequency) continue;
            offset = i;
            frequency = freq;
        }
        for (int i = 0; i < len; ++i) {
            Atom a1 = ca1Seq[align[0][0][i]];
            int n1 = a1.getGroup().getResidueNumber().getSeqNum();
            Atom a2 = ca2Seq[align[0][1][i]];
            n2 = a2.getGroup().getResidueNumber().getSeqNum();
            if (n2 - offset != n1) continue;
            align1.add(align[0][0][i]);
            align2.add(align[0][1][i]);
        }
        return align1.size();
    }

    private void createAlignedCAlphaAtoms() {
        List<Integer> indices = this.getReferenceResidueIndices();
        this.alignmentLength = indices.size();
        this.alignedCAlphaAtoms = new ArrayList<Atom[]>();
        for (UniqueSequenceList u : this.uniqueSequenceList) {
            List<Integer> alignment1 = u.getAlignment1();
            List<Integer> alignment2 = u.getAlignment2();
            ArrayList<Integer> alignmentIndices = new ArrayList<Integer>();
            for (int i = 0; i < alignment1.size(); ++i) {
                int a1 = alignment1.get(i);
                if (!indices.contains(a1)) continue;
                alignmentIndices.add(alignment2.get(i));
            }
            Atom[] unalignedAtoms = u.getCalphaAtoms();
            Atom[] alignedAtoms = new Atom[alignmentIndices.size()];
            for (int j = 0; j < alignedAtoms.length; ++j) {
                alignedAtoms[j] = unalignedAtoms[(Integer)alignmentIndices.get(j)];
            }
            this.alignedCAlphaAtoms.add(alignedAtoms);
        }
    }

    private List<Integer> getReferenceResidueIndices() {
        ArrayList<Integer> indices = new ArrayList<Integer>(this.uniqueSequenceList.get(0).getAlignment1());
        for (UniqueSequenceList u : this.uniqueSequenceList) {
            indices.retainAll(u.getAlignment1());
        }
        return indices;
    }
}

