/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.HetatomImpl;

public class AminoAcidImpl
extends HetatomImpl
implements AminoAcid {
    private static final long serialVersionUID = -6018854413829044230L;
    public static final GroupType type = GroupType.AMINOACID;
    private Character amino_char = null;
    private String recordType = "ATOM";

    @Override
    public GroupType getType() {
        return type;
    }

    @Override
    public Atom getN() {
        return this.getAtom("N");
    }

    @Override
    public Atom getCA() {
        return this.getAtom("CA");
    }

    @Override
    public Atom getC() {
        return this.getAtom("C");
    }

    @Override
    public Atom getO() {
        return this.getAtom("O");
    }

    @Override
    public Atom getCB() {
        return this.getAtom("CB");
    }

    @Override
    public Character getAminoType() {
        return this.amino_char;
    }

    @Override
    public void setAminoType(Character aa) {
        this.amino_char = aa;
    }

    @Override
    public void setRecordType(String recordName) {
        this.recordType = recordName;
    }

    @Override
    public String getRecordType() {
        return this.recordType;
    }

    @Override
    public String toString() {
        String str = "AminoAcid " + this.recordType + ":" + this.pdb_name + " " + this.amino_char + " " + this.residueNumber + " " + this.pdb_flag + " " + this.recordType;
        if (this.pdb_flag) {
            str = str + " atoms: " + this.atoms.size();
        }
        if (!this.getAltLocs().isEmpty()) {
            str = str + " has altLocs :" + this.getAltLocs().size();
        }
        return str;
    }

    @Override
    public void setPDBName(String s) {
        this.pdb_name = s;
    }

    @Override
    public Object clone() {
        AminoAcidImpl n = new AminoAcidImpl();
        n.setPDBFlag(this.has3D());
        n.setResidueNumber(this.getResidueNumber());
        n.setPDBName(this.getPDBName());
        n.setAminoType(this.getAminoType());
        n.setRecordType(this.recordType);
        for (Atom atom1 : this.atoms) {
            Atom atom = (Atom)atom1.clone();
            n.addAtom(atom);
            atom.setGroup(n);
        }
        if (this.getAltLocs() != null && !this.getAltLocs().isEmpty()) {
            for (Group altLocGroup : this.getAltLocs()) {
                Group nAltLocGroup = (Group)altLocGroup.clone();
                n.addAltLoc(nAltLocGroup);
            }
        }
        if (this.chemComp != null) {
            n.setChemComp(this.chemComp);
        }
        return n;
    }
}

