/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ws.alignment.qblast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.ws.alignment.RemotePairwiseAlignmentOutputProperties;
import org.biojava.nbio.ws.alignment.qblast.BlastOutputAlignmentFormatEnum;
import org.biojava.nbio.ws.alignment.qblast.BlastOutputFormatEnum;
import org.biojava.nbio.ws.alignment.qblast.BlastOutputParameterEnum;

public class NCBIQBlastOutputProperties
implements RemotePairwiseAlignmentOutputProperties {
    private static final long serialVersionUID = -9202060390925345163L;
    private Map<BlastOutputParameterEnum, String> param = new HashMap<BlastOutputParameterEnum, String>();

    public NCBIQBlastOutputProperties() {
        this.setOutputOption(BlastOutputParameterEnum.FORMAT_TYPE, BlastOutputFormatEnum.XML.name());
        this.setOutputOption(BlastOutputParameterEnum.ALIGNMENT_VIEW, BlastOutputAlignmentFormatEnum.Pairwise.name());
        this.setOutputOption(BlastOutputParameterEnum.DESCRIPTIONS, "100");
        this.setOutputOption(BlastOutputParameterEnum.ALIGNMENTS, "100");
    }

    @Override
    public String getOutputOption(String key) {
        return this.getOutputOption(BlastOutputParameterEnum.valueOf(key));
    }

    @Override
    public void setOutputOption(String key, String val) {
        this.setOutputOption(BlastOutputParameterEnum.valueOf(key), val);
    }

    public String getOutputOption(BlastOutputParameterEnum key) {
        return this.param.get((Object)key);
    }

    public void setOutputOption(BlastOutputParameterEnum key, String value) {
        this.param.put(key, value);
    }

    @Override
    public Set<String> getOutputOptions() {
        HashSet<String> result = new HashSet<String>();
        for (BlastOutputParameterEnum parameter : this.param.keySet()) {
            result.add(parameter.name());
        }
        return result;
    }

    public void removeOutputOption(BlastOutputParameterEnum key) {
        this.param.remove((Object)key);
    }

    public String getOutputFormat() {
        return this.getOutputOption(BlastOutputParameterEnum.FORMAT_TYPE);
    }

    public void setOutputFormat(BlastOutputFormatEnum formatType) {
        this.setOutputOption(BlastOutputParameterEnum.FORMAT_TYPE, formatType.name());
        if (BlastOutputFormatEnum.HTML.equals((Object)formatType)) {
            this.setOutputOption(BlastOutputParameterEnum.NOHEADER, "true");
            this.setOutputOption(BlastOutputParameterEnum.SHOW_OVERVIEW, "false");
            this.setOutputOption(BlastOutputParameterEnum.SHOW_LINKOUT, "false");
        } else {
            this.removeOutputOption(BlastOutputParameterEnum.NOHEADER);
            this.removeOutputOption(BlastOutputParameterEnum.SHOW_OVERVIEW);
            this.removeOutputOption(BlastOutputParameterEnum.SHOW_LINKOUT);
        }
    }

    public String getAlignmentOutputFormat() {
        return this.getOutputOption(BlastOutputParameterEnum.ALIGNMENT_VIEW);
    }

    public void setAlignmentOutputFormat(BlastOutputAlignmentFormatEnum alignmentFormat) {
        this.setOutputOption(BlastOutputParameterEnum.ALIGNMENT_VIEW, alignmentFormat.name());
    }

    public int getDescriptionNumber() {
        return Integer.parseInt(this.getOutputOption(BlastOutputParameterEnum.DESCRIPTIONS));
    }

    public void setDescriptionNumber(int number) {
        this.setOutputOption(BlastOutputParameterEnum.DESCRIPTIONS, Integer.toString(number));
    }

    public int getAlignmentNumber() {
        return Integer.parseInt(this.getOutputOption(BlastOutputParameterEnum.ALIGNMENTS));
    }

    public void setAlignmentNumber(int number) {
        this.setOutputOption(BlastOutputParameterEnum.ALIGNMENTS, Integer.toString(number));
    }
}

