/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.regex.Pattern;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00114", priority=Priority.MAJOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class BadInterfaceName_S00114_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S00114";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S00114");
    private static final String DEFAULT_FORMAT = "^[A-Z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", defaultValue="^[A-Z][a-zA-Z0-9]*$")
    public String format = "^[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (tree.is(Tree.Kind.INTERFACE) && !this.pattern.matcher(tree.simpleName().name()).matches()) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Rename this interface name to match the regular expression '" + this.format + "'.");
        }
        super.visitClass(tree);
    }
}

