/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;

@Rule(key="S1696", priority=Priority.MAJOR, tags={"error-handling"})
public class CatchNPECheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1696";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1696");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCatch(CatchTree tree) {
        super.visitCatch(tree);
        Tree typeTree = tree.parameter().type();
        if (typeTree.is(Tree.Kind.UNION_TYPE)) {
            UnionTypeTree unionTypeTree = (UnionTypeTree)typeTree;
            for (Tree typeAlternativeTree : unionTypeTree.typeAlternatives()) {
                this.checkType(typeAlternativeTree);
            }
        } else {
            this.checkType(typeTree);
        }
    }

    private void checkType(Tree tree) {
        MemberSelectExpressionTree memberSelectTree2;
        ExpressionTree tree2;
        MemberSelectExpressionTree memberSelectTree;
        if (tree.is(Tree.Kind.IDENTIFIER)) {
            String name = ((IdentifierTree)tree).name();
            if (this.isNPE(name)) {
                this.addIssue(tree);
            }
        } else if (tree.is(Tree.Kind.MEMBER_SELECT) && this.isNPE((memberSelectTree = (MemberSelectExpressionTree)tree).identifier().name()) && (tree2 = memberSelectTree.expression()).is(Tree.Kind.MEMBER_SELECT) && "lang".equals((memberSelectTree2 = (MemberSelectExpressionTree)tree2).identifier().name()) && memberSelectTree2.expression().is(Tree.Kind.IDENTIFIER) && "java".equals(((IdentifierTree)memberSelectTree2.expression()).name())) {
            this.addIssue(tree);
        }
    }

    private boolean isNPE(String name) {
        return "NullPointerException".equals(name);
    }

    private void addIssue(Tree tree) {
        this.context.addIssue(tree, this.ruleKey, "Avoid catching NullPointerException.");
    }
}

