/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1166", priority=Priority.MAJOR, tags={"error-handling"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CatchUsesExceptionWithContextCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1166";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1166");
    private static final String EXCLUDED_EXCEPTION_TYPE = "java.lang.InterruptedException, java.lang.NumberFormatException, java.text.ParseException, java.net.MalformedURLException";
    @RuleProperty(key="exceptions", defaultValue="java.lang.InterruptedException, java.lang.NumberFormatException, java.text.ParseException, java.net.MalformedURLException")
    public String exceptionsCommaSeparated = "java.lang.InterruptedException, java.lang.NumberFormatException, java.text.ParseException, java.net.MalformedURLException";
    private JavaFileScannerContext context;
    private Deque<Collection<IdentifierTree>> validUsagesStack;
    private Iterable<String> exceptions;
    private List<String> exceptionIdentifiers;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.validUsagesStack = new ArrayDeque<Collection<IdentifierTree>>();
        this.exceptions = Splitter.on((String)",").trimResults().split((CharSequence)this.exceptionsCommaSeparated);
        this.exceptionIdentifiers = Lists.newArrayList();
        for (String exception : this.exceptions) {
            this.exceptionIdentifiers.add(exception.substring(exception.lastIndexOf(".") + 1));
        }
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitCatch(CatchTree tree) {
        if (!this.isExcludedType(tree.parameter().type())) {
            SemanticModel semanticModel = (SemanticModel)this.context.getSemanticModel();
            Symbol exception = semanticModel.getSymbol((Tree)tree.parameter());
            this.validUsagesStack.addFirst(Lists.newArrayList((Iterable)semanticModel.getUsages(exception)));
            super.visitCatch(tree);
            Collection<IdentifierTree> usages = this.validUsagesStack.pop();
            if (usages.isEmpty()) {
                this.context.addIssue((Tree)tree, this.ruleKey, "Either log or rethrow this exception.");
            }
        }
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        IdentifierTree identifier = null;
        ExpressionTree expression = tree.expression();
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            identifier = (IdentifierTree)expression;
        } else if (expression.is(Tree.Kind.PARENTHESIZED_EXPRESSION) && ((ParenthesizedTree)expression).expression().is(Tree.Kind.IDENTIFIER)) {
            identifier = (IdentifierTree)((ParenthesizedTree)expression).expression();
        }
        if (!this.validUsagesStack.isEmpty() && identifier != null) {
            Iterator<Collection<IdentifierTree>> iterator = this.validUsagesStack.iterator();
            while (iterator.hasNext()) {
                iterator.next().remove(identifier);
            }
        }
        super.visitMemberSelectExpression(tree);
    }

    private boolean isExcludedType(Tree tree) {
        return this.isUnqualifiedExcludedType(tree) || this.isQualifiedExcludedType(tree);
    }

    private boolean isUnqualifiedExcludedType(Tree tree) {
        return tree.is(Tree.Kind.IDENTIFIER) && this.exceptionIdentifiers.contains(((IdentifierTree)tree).name());
    }

    private boolean isQualifiedExcludedType(Tree tree) {
        if (!tree.is(Tree.Kind.MEMBER_SELECT)) {
            return false;
        }
        LinkedList<String> pieces = new LinkedList<String>();
        MemberSelectExpressionTree expr = (MemberSelectExpressionTree)tree;
        while (expr.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mse = expr;
            pieces.push(mse.identifier().name());
            pieces.push(".");
            expr = mse.expression();
        }
        if (expr.is(Tree.Kind.IDENTIFIER)) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return Iterables.contains(this.exceptions, (Object)sb.toString());
    }
}

