/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1153", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class ConcatenationWithStringValueOfCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.ADDITIVE_EXPRESSION});
    }

    public void visitNode(AstNode node) {
        boolean seenStringLiteral = false;
        for (AstNode child : node.getChildren()) {
            if (!seenStringLiteral) {
                seenStringLiteral = ConcatenationWithStringValueOfCheck.isStringLiteral(child);
                continue;
            }
            if (!ConcatenationWithStringValueOfCheck.isStringValueOfCall(child)) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Directly append the argument of String.valueOf().", child, new Object[0]);
        }
    }

    private static boolean isStringLiteral(AstNode node) {
        return node.getToken().equals(node.getLastToken()) && node.getTokenValue().startsWith("\"");
    }

    private static boolean isStringValueOfCall(AstNode node) {
        AstNode identifierSuffix = node.getFirstChild(new AstNodeType[]{JavaGrammar.IDENTIFIER_SUFFIX});
        return node.is(new AstNodeType[]{JavaGrammar.PRIMARY}) && identifierSuffix != null && ConcatenationWithStringValueOfCheck.hasSingleArgumentIdentifierSuffix(identifierSuffix) && ConcatenationWithStringValueOfCheck.isStringValueOfQualifiedIdentifier(node.getFirstChild(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER}));
    }

    private static boolean hasSingleArgumentIdentifierSuffix(AstNode node) {
        AstNode arguments = node.getFirstChild(new AstNodeType[]{JavaGrammar.ARGUMENTS});
        return arguments != null && arguments.hasDirectChildren(new AstNodeType[]{JavaGrammar.EXPRESSION}) && !arguments.hasDirectChildren(new AstNodeType[]{JavaPunctuator.COMMA});
    }

    private static boolean isStringValueOfQualifiedIdentifier(AstNode node) {
        return node.getNumberOfChildren() == 3 && "String".equals(node.getTokenOriginalValue()) && "valueOf".equals(node.getLastChild().getTokenOriginalValue());
    }
}

