/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1862", priority=Priority.CRITICAL, tags={"bug", "unused"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class DuplicateConditionIfElseIfCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1862";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1862");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitIfStatement(IfStatementTree tree) {
        ExpressionTree condition = tree.condition();
        StatementTree statement = tree.elseStatement();
        while (statement != null && statement.is(Tree.Kind.IF_STATEMENT)) {
            IfStatementTree ifStatement = (IfStatementTree)statement;
            if (SyntacticEquivalence.areEquivalent((Tree)condition, (Tree)ifStatement.condition())) {
                this.context.addIssue((Tree)ifStatement.condition(), this.ruleKey, "This branch can not be reached because the condition duplicates a previous condition in the same sequence of \"if/else if\" statements");
            }
            statement = ifStatement.elseStatement();
        }
        super.visitIfStatement(tree);
    }
}

