/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1210", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class EqualsNotOverridenWithCompareToCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1210";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1210");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if ((tree.is(Tree.Kind.CLASS) || tree.is(Tree.Kind.ENUM)) && this.isComparable(tree)) {
            boolean hasEquals = false;
            Tree compare = null;
            for (Tree member : tree.members()) {
                if (!member.is(Tree.Kind.METHOD)) continue;
                MethodTree method = (MethodTree)member;
                if (this.isEqualsMethod(method)) {
                    hasEquals = true;
                    continue;
                }
                if (!this.isCompareToMethod(method)) continue;
                compare = member;
            }
            if (compare != null && !hasEquals) {
                this.context.addIssue(compare, this.ruleKey, "Override \"equals(Object obj)\" to comply with the contract of the \"compareTo(T o)\" method.");
            }
        }
        super.visitClass(tree);
    }

    private boolean isCompareToMethod(MethodTree method) {
        String name = method.simpleName().name();
        return "compareTo".equals(name) && this.returnsInt(method) && method.parameters().size() == 1;
    }

    private boolean isEqualsMethod(MethodTree method) {
        String name = method.simpleName().name();
        return "equals".equals(name) && this.hasObjectParam(method) && this.returnsBoolean(method);
    }

    private boolean isComparable(ClassTree tree) {
        Symbol.TypeSymbol typeSymbol = ((ClassTreeImpl)tree).getSymbol();
        if (typeSymbol == null) {
            return false;
        }
        for (Type type : typeSymbol.getInterfaces()) {
            if (!"Comparable".equals(((Type.ClassType)type).getSymbol().getName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasObjectParam(MethodTree tree) {
        boolean result = false;
        if (tree.parameters().size() == 1 && ((VariableTree)tree.parameters().get(0)).type().is(Tree.Kind.IDENTIFIER)) {
            result = ((IdentifierTree)((VariableTree)tree.parameters().get(0)).type()).name().endsWith("Object");
        }
        return result;
    }

    private boolean returnsBoolean(MethodTree tree) {
        Symbol.MethodSymbol methodSymbol = ((MethodTreeImpl)tree).getSymbol();
        return methodSymbol != null && methodSymbol.getReturnType().getType().isTagged(8);
    }

    private boolean returnsInt(MethodTree tree) {
        Symbol.MethodSymbol methodSymbol = ((MethodTreeImpl)tree).getSymbol();
        return methodSymbol != null && methodSymbol.getReturnType().getType().isTagged(4);
    }
}

