/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Map;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.ast.AstSelect;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="HiddenFieldCheck", priority=Priority.MAJOR, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class HiddenFieldCheck
extends SquidCheck<LexerlessGrammar> {
    private static final AstNodeType[] LOCAL_VARIABLE_TYPES = new AstNodeType[]{JavaGrammar.LOCAL_VARIABLE_DECLARATION_STATEMENT, JavaGrammar.FOR_INIT};
    private final Stack<Map<String, Integer>> fields = new Stack();

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_BODY});
        this.subscribeTo(LOCAL_VARIABLE_TYPES);
    }

    public void visitFile(AstNode node) {
        this.fields.clear();
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.CLASS_BODY})) {
            this.fields.push(HiddenFieldCheck.getFields(node));
        } else if (!HiddenFieldCheck.isInStaticBlock(node)) {
            this.checkLocalVariables(node);
        }
    }

    private static boolean isInStaticBlock(AstNode node) {
        AstSelect query = node.select().firstAncestor(new AstNodeType[]{JavaGrammar.CLASS_BODY_DECLARATION, JavaGrammar.CLASS_INIT_DECLARATION}).children(new AstNodeType[]{JavaGrammar.MODIFIER, JavaKeyword.STATIC});
        for (AstNode modifierOrStatic : query) {
            if (!modifierOrStatic.is(new AstNodeType[]{JavaKeyword.STATIC}) && !modifierOrStatic.hasDirectChildren(new AstNodeType[]{JavaKeyword.STATIC})) continue;
            return true;
        }
        return false;
    }

    public void leaveNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.CLASS_BODY})) {
            this.fields.pop();
        }
    }

    private void checkLocalVariables(AstNode node) {
        AstNode variableDeclarators = node.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATORS});
        if (variableDeclarators != null) {
            for (AstNode variableDeclarator : variableDeclarators.getChildren(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR})) {
                this.checkLocalVariable(variableDeclarator.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
            }
        }
    }

    private void checkLocalVariable(AstNode node) {
        for (Map classFields : Lists.reverse(this.fields)) {
            String identifier;
            Integer hiddenFieldLine = (Integer)classFields.get(identifier = node.getTokenOriginalValue());
            if (hiddenFieldLine == null) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Rename \"" + identifier + "\" which hides the field declared at line " + hiddenFieldLine + ".", node, new Object[0]);
            return;
        }
    }

    private static Map<String, Integer> getFields(AstNode node) {
        AstSelect fieldIdentifiers = node.select().children((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION).children((AstNodeType)JavaGrammar.MEMBER_DECL).children((AstNodeType)JavaGrammar.FIELD_DECLARATION).children((AstNodeType)JavaGrammar.VARIABLE_DECLARATORS).children((AstNodeType)JavaGrammar.VARIABLE_DECLARATOR).children((AstNodeType)JavaTokenType.IDENTIFIER);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AstNode fieldIdentifier : fieldIdentifiers) {
            builder.put((Object)fieldIdentifier.getTokenOriginalValue(), (Object)fieldIdentifier.getTokenLine());
        }
        return builder.build();
    }
}

