/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1150", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ImplementsEnumerationCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_TYPE_LIST});
    }

    public void visitNode(AstNode node) {
        for (AstNode classType : node.getChildren(new AstNodeType[]{JavaGrammar.CLASS_TYPE})) {
            if (!ImplementsEnumerationCheck.hasSingleIdentifier(classType) || !"Enumeration".equals(classType.getTokenOriginalValue())) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Implement Iterator rather than Enumeration.", classType, new Object[0]);
        }
    }

    private static boolean hasSingleIdentifier(AstNode node) {
        return !node.hasDirectChildren(new AstNodeType[]{JavaPunctuator.DOT});
    }
}

