/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1611", priority=Priority.MINOR, tags={"java8"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class LambdaOptionalParenthesisCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.LAMBDA_PARAMETERS});
    }

    public void visitNode(AstNode node) {
        if (!node.hasDirectChildren(new AstNodeType[]{JavaGrammar.FORMAL_PARAMETERS}) && this.hasOneParameterWithParenthesis(node)) {
            String identifier = node.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenValue();
            this.getContext().createLineViolation((CodeCheck)this, "Remove the parentheses around the \"" + identifier + "\" parameter", node, new Object[0]);
        }
    }

    private boolean hasOneParameterWithParenthesis(AstNode node) {
        return node.getChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER}).size() == 1 && node.getFirstChild().is(new AstNodeType[]{JavaPunctuator.LPAR});
    }
}

