/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceMethod;
import org.sonar.squidbridge.checks.ChecksHelper;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="MethodCyclomaticComplexity", priority=Priority.MAJOR, tags={"brain-overload"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class MethodComplexityCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAX = 10;
    @RuleProperty(defaultValue="10")
    private int max = 10;

    public void init() {
        MethodHelper.subscribe((SquidAstVisitor)this);
    }

    public void leaveNode(AstNode node) {
        SourceMethod sourceMethod = (SourceMethod)this.getContext().peekSourceCode();
        int complexity = ChecksHelper.getRecursiveMeasureInt((SourceCode)sourceMethod, (MetricDef)JavaMetric.COMPLEXITY);
        if (complexity > this.max) {
            this.getContext().createLineViolation((CodeCheck)this, "The Cyclomatic Complexity of this method \"{0}\" is {1,number,integer} which is greater than {2,number,integer} authorized.", node, new Object[]{new MethodHelper(node).getName().getTokenValue(), complexity, this.max});
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

