/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Stack;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1142", priority=Priority.MAJOR, tags={"brain-overload"})
public class MethodWithExcessiveReturnsCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(defaultValue="3")
    public int max = 3;
    private final Stack<Integer> returnStatementCounter = new Stack();

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.RETURN_STATEMENT});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_BODY_DECLARATION});
    }

    public void visitFile(AstNode node) {
        this.returnStatementCounter.clear();
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.RETURN_STATEMENT})) {
            this.setReturnStatementCounter(this.getReturnStatementCounter() + 1);
        } else {
            this.returnStatementCounter.push(0);
        }
    }

    public void leaveNode(AstNode node) {
        if (node.is(new AstNodeType[]{JavaGrammar.CLASS_BODY_DECLARATION})) {
            if (MethodWithExcessiveReturnsCheck.isMethod(node) && this.getReturnStatementCounter() > this.max) {
                this.getContext().createLineViolation((CodeCheck)this, "Reduce the number of returns of this method " + this.getReturnStatementCounter() + ", down to the maximum allowed " + this.max + ".", node, new Object[0]);
            }
            this.returnStatementCounter.pop();
        }
    }

    private static boolean isMethod(AstNode node) {
        return !node.hasDirectChildren(new AstNodeType[]{JavaGrammar.CLASS_INIT_DECLARATION});
    }

    private int getReturnStatementCounter() {
        return this.returnStatementCounter.peek();
    }

    private void setReturnStatementCounter(int value) {
        this.returnStatementCounter.pop();
        this.returnStatementCounter.push(value);
    }
}

