/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ModifiersOrderCheck", priority=Priority.MINOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class ModifiersOrderCheck
extends SquidCheck<LexerlessGrammar> {
    private static final AstNodeType[] EXPECTED_ORDER = new AstNodeType[]{JavaGrammar.ANNOTATION, JavaKeyword.PUBLIC, JavaKeyword.PROTECTED, JavaKeyword.PRIVATE, JavaKeyword.ABSTRACT, JavaKeyword.STATIC, JavaKeyword.FINAL, JavaKeyword.TRANSIENT, JavaKeyword.VOLATILE, JavaKeyword.SYNCHRONIZED, JavaKeyword.NATIVE, JavaKeyword.DEFAULT, JavaKeyword.STRICTFP};

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.MODIFIER});
    }

    public void visitNode(AstNode node) {
        List<AstNode> modifiers;
        AstNode badlyOrderedModifier;
        if (ModifiersOrderCheck.isFirstModifer(node) && (badlyOrderedModifier = ModifiersOrderCheck.isBadlyOrdered(modifiers = ModifiersOrderCheck.getModifiers(node))) != null) {
            this.getContext().createLineViolation((CodeCheck)this, "Reorder the modifiers to comply with the Java Language Specification.", badlyOrderedModifier, new Object[0]);
        }
    }

    private static boolean isFirstModifer(AstNode node) {
        return node.getPreviousSibling() == null;
    }

    private static List<AstNode> getModifiers(AstNode node) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)node);
        for (AstNode nextSibling = node.getNextSibling(); nextSibling != null && nextSibling.is(new AstNodeType[]{JavaGrammar.MODIFIER}); nextSibling = nextSibling.getNextSibling()) {
            builder.add((Object)nextSibling);
        }
        return builder.build();
    }

    private static AstNode isBadlyOrdered(List<AstNode> modifiers) {
        int expectedIndex = 0;
        for (AstNode modifier : modifiers) {
            while (expectedIndex < EXPECTED_ORDER.length && !modifier.getFirstChild().is(new AstNodeType[]{EXPECTED_ORDER[expectedIndex]})) {
                ++expectedIndex;
            }
            if (expectedIndex != EXPECTED_ORDER.length) continue;
            return modifier;
        }
        return null;
    }
}

