/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1171", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class NonStaticClassInitializerCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_INIT_DECLARATION});
    }

    public void visitNode(AstNode node) {
        if (!NonStaticClassInitializerCheck.isStatic(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Move the contents of this initializer to a standard constructor or to field initializers.", node, new Object[0]);
        }
    }

    private static boolean isStatic(AstNode node) {
        return node.hasDirectChildren(new AstNodeType[]{JavaKeyword.STATIC});
    }
}

