/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.expression.AssignmentExpressionTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

@Rule(key="S1643", priority=Priority.MAJOR, tags={"performance"})
public class StringConcatenationInLoopCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1643";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1643");
    private JavaFileScannerContext context;
    private int loopLevel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.loopLevel = 0;
        this.scan((Tree)context.getTree());
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (this.loopLevel > 0 && this.isStringConcatenation(tree)) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Use a StringBuilder instead.");
        }
        super.visitAssignmentExpression(tree);
    }

    private boolean isStringConcatenation(AssignmentExpressionTree tree) {
        return this.isString(((AssignmentExpressionTreeImpl)tree).getType()) && this.isConcatenation(tree);
    }

    private boolean isConcatenation(AssignmentExpressionTree tree) {
        return tree.is(Tree.Kind.PLUS_ASSIGNMENT) || tree.is(Tree.Kind.ASSIGNMENT) && this.removeParenthesis((Tree)tree.expression()).is(Tree.Kind.PLUS);
    }

    private Tree removeParenthesis(Tree tree) {
        Tree result = tree;
        while (result.is(Tree.Kind.PARENTHESIZED_EXPRESSION)) {
            result = ((ParenthesizedTree)result).expression();
        }
        return result;
    }

    private boolean isString(Type type) {
        if (type.isTagged(10)) {
            Symbol.TypeSymbol typeSymbol = ((Type.ClassType)type).getSymbol();
            return "String".equals(typeSymbol.getName()) && "java.lang".equals(typeSymbol.owner().getName());
        }
        return false;
    }

    public void visitForEachStatement(ForEachStatement tree) {
        ++this.loopLevel;
        super.visitForEachStatement(tree);
        --this.loopLevel;
    }

    public void visitForStatement(ForStatementTree tree) {
        ++this.loopLevel;
        super.visitForStatement(tree);
        --this.loopLevel;
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        ++this.loopLevel;
        super.visitWhileStatement(tree);
        --this.loopLevel;
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        ++this.loopLevel;
        super.visitDoWhileStatement(tree);
        --this.loopLevel;
    }
}

