/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="SwitchLastCaseIsDefaultCheck", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SwitchLastCaseIsDefaultCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.SWITCH_STATEMENT});
    }

    public void visitNode(AstNode node) {
        AstNode defaultLabel = this.getDefaultLabel(node);
        AstNode lastLabel = this.getLastLabel(node);
        if (defaultLabel == null) {
            this.getContext().createLineViolation((CodeCheck)this, "Add a default case to this switch.", node, new Object[0]);
        } else if (!defaultLabel.equals(lastLabel)) {
            this.getContext().createLineViolation((CodeCheck)this, "Move this default to the end of the switch.", defaultLabel, new Object[0]);
        }
    }

    private AstNode getDefaultLabel(AstNode node) {
        Iterator it = node.select().children((AstNodeType)JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUPS).children((AstNodeType)JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUP).children((AstNodeType)JavaGrammar.SWITCH_LABEL).children((AstNodeType)JavaKeyword.DEFAULT).iterator();
        return !it.hasNext() ? null : ((AstNode)it.next()).getParent();
    }

    private AstNode getLastLabel(AstNode node) {
        ImmutableList labels = ImmutableList.copyOf((Iterable)node.select().children((AstNodeType)JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUPS).children((AstNodeType)JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUP).children((AstNodeType)JavaGrammar.SWITCH_LABEL));
        return labels.isEmpty() ? null : (AstNode)labels.get(labels.size() - 1);
    }
}

