/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1219", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class SwitchWithLabelsCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUP});
    }

    public void visitNode(AstNode node) {
        AstNode blockStatements = node.getFirstChild(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENTS});
        for (AstNode blockStatement : blockStatements.getChildren(new AstNodeType[]{JavaGrammar.BLOCK_STATEMENT})) {
            if (!SwitchWithLabelsCheck.isLabeledBlockStatement(blockStatement)) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Remove this misleading \"" + blockStatement.getTokenOriginalValue() + "\" label.", blockStatement, new Object[0]);
        }
    }

    private static boolean isLabeledBlockStatement(AstNode node) {
        AstNode statement = node.getFirstChild(new AstNodeType[]{JavaGrammar.STATEMENT});
        return statement != null && statement.hasDirectChildren(new AstNodeType[]{JavaGrammar.LABELED_STATEMENT});
    }
}

