/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S106", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SystemOutOrErrUsageCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final State[][] TRANSITIONS = new State[State.values().length][Symbol.values().length];
    private State currentState;

    public void visitFile(@Nullable AstNode node) {
        this.currentState = State.EXPECTING_SYSTEM;
    }

    public void visitToken(Token token) {
        this.currentState = TRANSITIONS[this.currentState.ordinal()][SystemOutOrErrUsageCheck.getSymbol(token.getOriginalValue()).ordinal()];
        if (this.currentState == State.FOUND_ISSUE) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this usage of System.out or System.err by a logger.", token, new Object[0]);
            this.currentState = State.EXPECTING_SYSTEM;
        }
    }

    private static Symbol getSymbol(String value) {
        Symbol result = Symbol.OTHER;
        if (".".equals(value)) {
            result = Symbol.DOT;
        } else if ("System".equals(value)) {
            result = Symbol.SYSTEM;
        } else if ("out".equals(value) || "err".equals(value)) {
            result = Symbol.OUT_OR_ERR;
        }
        return result;
    }

    static {
        for (int i = 0; i < TRANSITIONS.length; ++i) {
            for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                SystemOutOrErrUsageCheck.TRANSITIONS[i][j] = State.EXPECTING_SYSTEM;
            }
        }
        SystemOutOrErrUsageCheck.TRANSITIONS[State.EXPECTING_SYSTEM.ordinal()][Symbol.SYSTEM.ordinal()] = State.EXPECTING_DOT;
        SystemOutOrErrUsageCheck.TRANSITIONS[State.EXPECTING_DOT.ordinal()][Symbol.DOT.ordinal()] = State.EXPECTING_OUT_OR_ERR;
        SystemOutOrErrUsageCheck.TRANSITIONS[State.EXPECTING_OUT_OR_ERR.ordinal()][Symbol.OUT_OR_ERR.ordinal()] = State.FOUND_ISSUE;
    }

    private static enum Symbol {
        OTHER,
        SYSTEM,
        DOT,
        OUT_OR_ERR;

    }

    private static enum State {
        EXPECTING_SYSTEM,
        EXPECTING_DOT,
        EXPECTING_OUT_OR_ERR,
        FOUND_ISSUE;

    }
}

