/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashMap;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00122", priority=Priority.MAJOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class TooManyStatementsPerLine_S00122_Check
extends SquidCheck<LexerlessGrammar> {
    private final Multiset<Integer> statementsPerLine = HashMultiset.create();
    private final Map<Integer, Integer> columnsByLine = new HashMap<Integer, Integer>();

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.STATEMENT, JavaGrammar.LOCAL_VARIABLE_DECLARATION_STATEMENT});
    }

    public boolean isExcluded(AstNode astNode) {
        AstNode statementNode = astNode.getFirstChild();
        return statementNode.is(new AstNodeType[]{JavaGrammar.BLOCK}) || statementNode.is(new AstNodeType[]{JavaGrammar.EMPTY_STATEMENT}) || statementNode.is(new AstNodeType[]{JavaGrammar.LABELED_STATEMENT});
    }

    public void visitFile(AstNode astNode) {
        this.statementsPerLine.clear();
        this.columnsByLine.clear();
    }

    public void visitNode(AstNode statementNode) {
        if (!this.isExcluded(statementNode)) {
            int lineStart = statementNode.getTokenLine();
            int lineEnd = statementNode.getLastToken().getLine();
            int columnStart = statementNode.getToken().getColumn();
            int columnEnd = statementNode.getLastToken().getColumn();
            if (!this.isNestedInStatement(lineStart, columnStart)) {
                this.statementsPerLine.add((Object)lineStart);
            }
            if (lineStart != lineEnd) {
                if (!this.isNestedInStatement(lineEnd, columnEnd)) {
                    this.statementsPerLine.add((Object)lineEnd);
                }
                this.columnsByLine.put(lineEnd, columnEnd);
            }
        }
    }

    private boolean isNestedInStatement(int line, int column) {
        if (this.columnsByLine.get(line) != null && this.columnsByLine.get(line) >= column) {
            this.columnsByLine.remove(line);
            return true;
        }
        return false;
    }

    public void leaveFile(AstNode astNode) {
        for (Multiset.Entry statementsAtLine : this.statementsPerLine.entrySet()) {
            if (statementsAtLine.getCount() <= 1) continue;
            this.getContext().createLineViolation((CodeCheck)this, "At most one statement is allowed per line, but {0} statements were found on this line.", ((Integer)statementsAtLine.getElement()).intValue(), new Object[]{statementsAtLine.getCount()});
        }
    }
}

