/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.java.ast.visitors.PublicApiVisitor;
import org.sonar.java.checks.PatternUtils;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="UndocumentedApi", priority=Priority.MAJOR, tags={"convention"})
public class UndocumentedApiCheck
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT_FOR_CLASSES = "**";
    private Pattern setterPattern = Pattern.compile("set[A-Z].*");
    private Pattern getterPattern = Pattern.compile("(get|is)[A-Z].*");
    @RuleProperty(key="forClasses", defaultValue="**")
    public String forClasses = "**";
    private WildcardPattern[] patterns;

    public void init() {
        PublicApiVisitor.subscribe((SquidCheck)this);
    }

    public void visitNode(AstNode node) {
        if (!this.isExcluded(node)) {
            String javadoc = PublicApiVisitor.getApiJavadoc((AstNode)node);
            if (javadoc == null) {
                this.getContext().createLineViolation((CodeCheck)this, "Document this public " + PublicApiVisitor.getType((AstNode)node) + ".", node, new Object[0]);
            } else {
                List<String> undocumentedParameters = UndocumentedApiCheck.getUndocumentedParameters(javadoc, UndocumentedApiCheck.getParameters(node));
                if (!undocumentedParameters.isEmpty()) {
                    this.getContext().createLineViolation((CodeCheck)this, "Document the parameter(s): " + Joiner.on((String)", ").join(undocumentedParameters), node, new Object[0]);
                }
                if (UndocumentedApiCheck.hasNonVoidReturnType(node) && !UndocumentedApiCheck.hasReturnJavadoc(javadoc)) {
                    this.getContext().createLineViolation((CodeCheck)this, "Document this method return value.", node, new Object[0]);
                }
            }
        }
    }

    private boolean isExcluded(AstNode node) {
        return this.isAccessor(node) || !this.isPublicApi(node) || !this.isMatchingPattern();
    }

    private boolean isAccessor(AstNode node) {
        boolean result = false;
        if (node.is(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST})) {
            MethodHelper methodHelper = new MethodHelper(node);
            String methodName = methodHelper.getName().getTokenOriginalValue();
            result = this.setterPattern.matcher(methodName).matches() && methodHelper.getParameters().size() == 1 || this.getterPattern.matcher(methodName).matches() && !methodHelper.hasParameters();
        }
        return result;
    }

    private boolean isPublicApi(AstNode node) {
        return PublicApiVisitor.isPublicApi((AstNode)node);
    }

    private boolean isMatchingPattern() {
        return WildcardPattern.match((WildcardPattern[])this.getPatterns(), (String)this.peekSourceClass().getKey());
    }

    private WildcardPattern[] getPatterns() {
        if (this.patterns == null) {
            this.patterns = PatternUtils.createPatterns(this.forClasses);
        }
        return this.patterns;
    }

    private static List<String> getUndocumentedParameters(String javadoc, List<String> parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String parameter : parameters) {
            if (UndocumentedApiCheck.hasParamJavadoc(javadoc, parameter)) continue;
            builder.add((Object)parameter);
        }
        return builder.build();
    }

    private static List<String> getParameters(AstNode node) {
        AstNode typeParameters;
        ImmutableList.Builder builder = ImmutableList.builder();
        AstNode formalParameters = node.getFirstChild(new AstNodeType[]{JavaGrammar.FORMAL_PARAMETERS});
        if (formalParameters != null) {
            for (AstNode parameter : formalParameters.getDescendants(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR_ID})) {
                builder.add((Object)parameter.getTokenOriginalValue());
            }
        }
        if ((typeParameters = node.getFirstChild(new AstNodeType[]{JavaGrammar.TYPE_PARAMETERS})) != null) {
            for (AstNode parameter : typeParameters.getChildren(new AstNodeType[]{JavaGrammar.TYPE_PARAMETER})) {
                builder.add((Object)("<" + parameter.getTokenOriginalValue() + ">"));
            }
        }
        return builder.build();
    }

    private static boolean hasParamJavadoc(String comment, String parameter) {
        return comment.matches("(?s).*@param\\s++" + parameter + ".*");
    }

    private static boolean hasNonVoidReturnType(AstNode node) {
        return node.is(new AstNodeType[]{JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST}) && !UndocumentedApiCheck.isGenericMethodReturningVoid(node);
    }

    private static boolean isGenericMethodReturningVoid(AstNode node) {
        return node.getParent().is(new AstNodeType[]{JavaGrammar.GENERIC_METHOD_OR_CONSTRUCTOR_REST}) && node.getParent().hasDirectChildren(new AstNodeType[]{JavaKeyword.VOID});
    }

    private static boolean hasReturnJavadoc(String comment) {
        return comment.contains("@return");
    }

    private final SourceClass peekSourceClass() {
        SourceCode sourceCode = this.getContext().peekSourceCode();
        if (sourceCode.isType(SourceClass.class)) {
            return (SourceClass)sourceCode;
        }
        return (SourceClass)sourceCode.getParent(SourceClass.class);
    }
}

