/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.java.checks.SerializableContract;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceMethod;

@Rule(key="UnusedPrivateMethod", priority=Priority.MAJOR, tags={"unused"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnusedPrivateMethodCheck
extends BytecodeVisitor {
    public static final String RULE_KEY = "UnusedPrivateMethod";
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        if (this.isPrivateUnused(asmMethod) && !this.isExcludedFromCheck(asmMethod)) {
            CheckMessage message = new CheckMessage((Object)this, "Private method '" + asmMethod.getName() + "(...)' is never used.", new Object[0]);
            SourceMethod sourceMethod = this.getSourceMethod(asmMethod);
            if (sourceMethod != null) {
                message.setLine(sourceMethod.getStartAtLine());
            }
            SourceFile file = this.getSourceFile(this.asmClass);
            file.log(message);
        }
    }

    private boolean isPrivateUnused(AsmMethod asmMethod) {
        return !asmMethod.isUsed() && asmMethod.isPrivate();
    }

    private boolean isExcludedFromCheck(AsmMethod asmMethod) {
        return asmMethod.isSynthetic() || asmMethod.isDefaultConstructor() || SerializableContract.methodMatch(asmMethod);
    }

    public String toString() {
        return "UnusedPrivateMethod rule";
    }
}

