/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1698", priority=Priority.MAJOR, tags={"error-handling"})
public class CompareObjectWithEqualsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1698";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1698");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitMethod(MethodTree tree) {
        if (!this.isEquals(tree)) {
            super.visitMethod(tree);
        }
    }

    private boolean isEquals(MethodTree tree) {
        String methodName = tree.simpleName().name();
        return "equals".equals(methodName) && this.hasObjectParam(tree) && this.returnsBoolean(tree);
    }

    private boolean returnsBoolean(MethodTree tree) {
        Symbol.MethodSymbol methodSymbol = ((MethodTreeImpl)tree).getSymbol();
        return methodSymbol != null && methodSymbol.getReturnType().getType().isTagged(8);
    }

    private boolean hasObjectParam(MethodTree tree) {
        boolean result = false;
        if (tree.parameters().size() == 1 && ((VariableTree)tree.parameters().get(0)).type().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            result = ((IdentifierTree)((VariableTree)tree.parameters().get(0)).type()).name().endsWith("Object");
        }
        return result;
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        Type rightOperandType;
        Type leftOperandType;
        super.visitBinaryExpression(tree);
        if ((tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO})) && !this.isNullComparison(leftOperandType = ((AbstractTypedTree)tree.leftOperand()).getSymbolType(), rightOperandType = ((AbstractTypedTree)tree.rightOperand()).getSymbolType()) && !this.isNumericalComparison(leftOperandType, rightOperandType) && (this.isClass(leftOperandType) || this.isClass(rightOperandType))) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Change this comparison to use the equals method.");
        }
    }

    private boolean isClass(Type operandType) {
        return operandType.isTagged(10) && !((Type.ClassType)operandType).getSymbol().isEnum();
    }

    private boolean isNullComparison(Type leftOperandType, Type rightOperandType) {
        return leftOperandType.isTagged(13) || rightOperandType.isTagged(13);
    }

    private boolean isNumericalComparison(Type leftOperandType, Type rightOperandType) {
        return leftOperandType.isNumerical() || rightOperandType.isNumerical();
    }
}

