/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1764", priority=Priority.MAJOR, tags={"cert"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class IdenticalOperandOnBinaryExpressionCheck
extends SubscriptionBaseVisitor {
    private static final List<Tree.Kind> SYMETRIC_OPERATORS = ImmutableList.builder().add((Object)Tree.Kind.EQUAL_TO).add((Object)Tree.Kind.NOT_EQUAL_TO).add((Object)Tree.Kind.AND).add((Object)Tree.Kind.XOR).add((Object)Tree.Kind.OR).add((Object)Tree.Kind.CONDITIONAL_AND).add((Object)Tree.Kind.CONDITIONAL_OR).build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.DIVIDE).add((Object)Tree.Kind.REMAINDER).add((Object)Tree.Kind.MINUS).add((Object)Tree.Kind.LEFT_SHIFT).add((Object)Tree.Kind.RIGHT_SHIFT).add((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT).add((Object)Tree.Kind.LESS_THAN).add((Object)Tree.Kind.GREATER_THAN).add((Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO).add((Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO).add((Object)Tree.Kind.EQUAL_TO).add((Object)Tree.Kind.NOT_EQUAL_TO).add((Object)Tree.Kind.AND).add((Object)Tree.Kind.XOR).add((Object)Tree.Kind.OR).add((Object)Tree.Kind.CONDITIONAL_AND).add((Object)Tree.Kind.CONDITIONAL_OR).build();
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
        if (this.hasEquivalentOperand(binaryExpressionTree)) {
            this.addIssue((Tree)binaryExpressionTree.rightOperand(), "Identical sub-expressions on both sides of operator \"" + binaryExpressionTree.operatorToken().text() + "\"");
        }
    }

    public boolean hasEquivalentOperand(BinaryExpressionTree tree) {
        if (this.isNanTest(tree) || this.isLeftShiftOnOne(tree)) {
            return false;
        }
        Tree.Kind binaryKind = ((JavaTree)tree).getKind();
        return this.areOperandEquivalent(tree.leftOperand(), tree.rightOperand(), binaryKind);
    }

    public boolean areOperandEquivalent(ExpressionTree left, ExpressionTree right, Tree.Kind binaryKind) {
        if (SyntacticEquivalence.areEquivalent((Tree)left, (Tree)right)) {
            return true;
        }
        if (SYMETRIC_OPERATORS.contains(binaryKind) && left.is(new Tree.Kind[]{binaryKind})) {
            return this.areOperandEquivalent(((BinaryExpressionTree)left).leftOperand(), right, binaryKind) || this.areOperandEquivalent(((BinaryExpressionTree)left).rightOperand(), right, binaryKind);
        }
        return false;
    }

    private boolean isNanTest(BinaryExpressionTree tree) {
        Type symbolType;
        return tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) && ((symbolType = ((AbstractTypedTree)tree.leftOperand()).getSymbolType()).isTagged(6) || symbolType.isTagged(7));
    }

    private boolean isLeftShiftOnOne(BinaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.LEFT_SHIFT}) && tree.leftOperand().is(new Tree.Kind[]{Tree.Kind.INT_LITERAL}) && tree.rightOperand().is(new Tree.Kind[]{Tree.Kind.INT_LITERAL})) {
            String left = ((LiteralTree)tree.leftOperand()).value();
            String right = ((LiteralTree)tree.rightOperand()).value();
            if ("1".equals(right) && "1".equals(left)) {
                return true;
            }
        }
        return false;
    }
}

