/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1150", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ImplementsEnumerationCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (Tree superInterface : classTree.superInterfaces()) {
            IdentifierTree identifierTree = null;
            if (superInterface.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                identifierTree = (IdentifierTree)superInterface;
            } else if (superInterface.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE}) && ((ParameterizedTypeTree)superInterface).type().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                identifierTree = (IdentifierTree)((ParameterizedTypeTree)superInterface).type();
            }
            if (!this.isEnumeration(identifierTree)) continue;
            this.addIssue(superInterface, "Implement Iterator rather than Enumeration.");
        }
    }

    private boolean isEnumeration(@Nullable IdentifierTree tree) {
        return tree != null && "Enumeration".equals(tree.name());
    }
}

