/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S138", priority=Priority.MAJOR, tags={"brain-overload"})
public class MethodTooBigCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAX = 100;
    @RuleProperty(defaultValue="100")
    public int max = 100;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        int lines;
        MethodTree methodTree = (MethodTree)tree;
        BlockTree block = methodTree.block();
        if (block != null && (lines = this.getLines(block)) > this.max) {
            this.addIssue((Tree)block.openBraceToken(), "This method has " + lines + " lines, which is greater than the " + this.max + " lines authorized. Split it into smaller methods.");
        }
    }

    private int getLines(BlockTree block) {
        return 1 + ((InternalSyntaxToken)block.closeBraceToken()).getLine() - ((InternalSyntaxToken)block.openBraceToken()).getLine();
    }
}

