/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1318", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ObjectEqualsNullCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String KEY = "S1318";
    private static final RuleKey RULE_KEY = RuleKey.of((String)"squid", (String)"S1318");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        super.visitMethodInvocation(tree);
        if (ObjectEqualsNullCheck.isCallToEquals(tree.methodSelect()) && tree.arguments().size() == 1 && ObjectEqualsNullCheck.isNull((ExpressionTree)tree.arguments().get(0))) {
            this.context.addIssue((Tree)tree, RULE_KEY, "Use \"object == null\" instead of \"object.equals(null)\" to test for nullity to prevent null pointer exceptions.");
        }
    }

    private static boolean isCallToEquals(ExpressionTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return false;
        }
        MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)tree;
        return "equals".equals(memberSelect.identifier().name());
    }

    private static boolean isNull(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }
}

