/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1148", priority=Priority.CRITICAL, tags={"error-handling"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class PrintStackTraceCalledWithoutArgumentCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1148";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1148");
    private JavaFileScannerContext context;
    private final Deque<Symbol.TypeSymbol> enclosingClass = new LinkedList<Symbol.TypeSymbol>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        Symbol.TypeSymbol enclosingSymbol = ((ClassTreeImpl)tree).getSymbol();
        this.enclosingClass.push(enclosingSymbol);
        super.visitClass(tree);
        this.enclosingClass.pop();
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        super.visitMethodInvocation(tree);
        if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            IdentifierTree identifierTree = ((MemberSelectExpressionTree)tree.methodSelect()).identifier();
            if (!this.enclosingClassExtendsThrowable() && "printStackTrace".equals(identifierTree.name()) && this.calledOnTypeInheritedFromThrowable(tree)) {
                this.context.addIssue((Tree)identifierTree, this.ruleKey, "Use a logger to log this exception.");
            }
        }
    }

    private boolean enclosingClassExtendsThrowable() {
        return this.enclosingClass.peek() != null && this.extendsThrowable((Type.ClassType)this.enclosingClass.peek().getType());
    }

    private boolean calledOnTypeInheritedFromThrowable(MethodInvocationTree tree) {
        Type type = ((AbstractTypedTree)((MemberSelectExpressionTree)tree.methodSelect()).expression()).getSymbolType();
        return this.extendsThrowable((Type.ClassType)type);
    }

    private boolean extendsThrowable(Type.ClassType type) {
        Symbol.TypeSymbol site = type.getSymbol();
        if (this.isThrowable(site)) {
            return true;
        }
        while (site.getSuperclass() != null) {
            if (!this.isThrowable(site = ((Type.ClassType)site.getSuperclass()).getSymbol())) continue;
            return true;
        }
        return false;
    }

    private boolean isThrowable(Symbol.TypeSymbol site) {
        return "Throwable".equals(site.getName()) && "java.lang".equals(site.owner().getName());
    }
}

