/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1126", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ReturnOfBooleanExpressionsCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.IF_STATEMENT);
    }

    public void visitNode(Tree tree) {
        IfStatementTree ifStatementTree = (IfStatementTree)tree;
        if (this.hasOneReturnBoolean(ifStatementTree.elseStatement()) && this.hasOneReturnBoolean(ifStatementTree.thenStatement())) {
            this.addIssue(tree, "Replace this if-then-else statement by a single return statement.");
        }
    }

    private boolean hasOneReturnBoolean(@Nullable StatementTree statementTree) {
        if (statementTree == null) {
            return false;
        }
        if (statementTree.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)statementTree;
            return block.body().size() == 1 && this.isReturnBooleanLiteral((StatementTree)block.body().get(0));
        }
        return this.isReturnBooleanLiteral(statementTree);
    }

    private boolean isReturnBooleanLiteral(StatementTree statementTree) {
        if (statementTree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            ReturnStatementTree returnStatement = (ReturnStatementTree)statementTree;
            return returnStatement.expression() != null && returnStatement.expression().is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL});
        }
        return false;
    }
}

