/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractSerializableInnerClassRule
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            this.visitClassTree((ClassTreeImpl)tree);
        }
    }

    private void visitClassTree(ClassTreeImpl classTree) {
        Symbol.TypeSymbol symbol = classTree.getSymbol();
        if (this.isInnerClass(symbol) && this.directlyImplementsSerializable(symbol)) {
            Symbol.TypeSymbol methodOwner;
            Symbol owner = symbol.owner();
            if (owner.isKind(2)) {
                Symbol.TypeSymbol ownerType = (Symbol.TypeSymbol)owner;
                if (this.isMatchingOuterClass(ownerType.getType()) && !symbol.isStatic()) {
                    this.addIssue((Tree)classTree, "Make this inner class static");
                }
            } else if (owner.isKind(16) && this.isMatchingOuterClass((methodOwner = (Symbol.TypeSymbol)owner.owner()).getType()) && !owner.isStatic()) {
                String methodName = owner.getName();
                this.addIssue((Tree)classTree, "Make \"" + methodName + "\" static");
            }
        }
    }

    private boolean isInnerClass(Symbol.TypeSymbol typeSymbol) {
        return !typeSymbol.equals(typeSymbol.outermostClass());
    }

    protected boolean isSerializable(Type type) {
        return type.isSubtypeOf("java.io.Serializable");
    }

    private boolean directlyImplementsSerializable(Symbol.TypeSymbol symbol) {
        for (Type type : symbol.getInterfaces()) {
            if (!type.is("java.io.Serializable")) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean isMatchingOuterClass(Type var1);
}

