/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.LinkedList;
import java.util.regex.Pattern;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00120", priority=Priority.MAJOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class BadPackageName_S00120_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String RULE_KEY = "S00120";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S00120");
    private static final String DEFAULT_FORMAT = "^[a-z]+(\\.[a-z][a-z0-9]*)*$";
    @RuleProperty(key="format", defaultValue="^[a-z]+(\\.[a-z][a-z0-9]*)*$")
    public String format = "^[a-z]+(\\.[a-z][a-z0-9]*)*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        String name;
        if (tree.packageName() != null && !this.pattern.matcher(name = this.concatenate(tree.packageName())).matches()) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Rename this package name to match the regular expression '" + this.format + "'.");
        }
    }

    private String concatenate(ExpressionTree tree) {
        LinkedList<String> pieces = new LinkedList<String>();
        ExpressionTree expr = tree;
        while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            pieces.push(mse.identifier().name());
            pieces.push(".");
            expr = mse.expression();
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return sb.toString();
    }
}

