/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2184", priority=Priority.MAJOR, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CastArithmeticOperandCheck
extends SubscriptionBaseVisitor {
    private static final Map<Tree.Kind, String> OPERATION_BY_KIND = ImmutableMap.builder().put((Object)Tree.Kind.PLUS, (Object)"addition").put((Object)Tree.Kind.MINUS, (Object)"substraction").put((Object)Tree.Kind.MULTIPLY, (Object)"multiplication").put((Object)Tree.Kind.DIVIDE, (Object)"division").build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            MethodTreeImpl methodTree;
            Type returnType;
            if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                AssignmentExpressionTree aet = (AssignmentExpressionTree)tree;
                Type varType = ((AbstractTypedTree)aet.variable()).getSymbolType();
                ExpressionTree expr = aet.expression();
                this.checkExpression(varType, expr);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree variableTree = (VariableTree)tree;
                Type varType = ((AbstractTypedTree)variableTree.type()).getSymbolType();
                ExpressionTree expr = variableTree.initializer();
                this.checkExpression(varType, expr);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.checkMethodInvocationArgument((MethodInvocationTreeImpl)tree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && this.isVarTypeErrorProne(returnType = (methodTree = (MethodTreeImpl)tree).getSymbol().getReturnType().getType())) {
                methodTree.accept((TreeVisitor)new ReturnStatementVisitor(returnType));
            }
        }
    }

    private void checkMethodInvocationArgument(MethodInvocationTreeImpl mit) {
        Symbol symbol = mit.getSymbol();
        if (symbol.isKind(16)) {
            List parametersTypes = ((Symbol.MethodSymbol)symbol).getParametersTypes();
            if (mit.arguments().size() == parametersTypes.size()) {
                int i = 0;
                for (Type argType : parametersTypes) {
                    this.checkExpression(argType, (ExpressionTree)mit.arguments().get(i));
                    ++i;
                }
            }
        }
    }

    private void checkExpression(Type varType, ExpressionTree expr) {
        Type exprType;
        if (expr != null && expr.is(new Tree.Kind[]{Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.PLUS, Tree.Kind.MINUS}) && this.isVarTypeErrorProne(varType) && (exprType = ((AbstractTypedTree)expr).getSymbolType()).isTagged(4)) {
            this.addIssue((Tree)expr, "Cast one of the operands of this " + OPERATION_BY_KIND.get(((JavaTree)expr).getKind()) + " operation to a \"" + varType.getSymbol().getName() + "\".");
        }
    }

    private boolean isVarTypeErrorProne(Type varType) {
        return varType.isTagged(5) || varType.isTagged(6) || varType.isTagged(7);
    }

    private class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private Type returnType;

        public ReturnStatementVisitor(Type returnType) {
            this.returnType = returnType;
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            CastArithmeticOperandCheck.this.checkExpression(this.returnType, tree.expression());
        }
    }
}

