/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1596", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CollectionsEmptyConstantsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1596";
    private static final RuleKey RULE = RuleKey.of((String)"squid", (String)"S1596");
    private static final Map<String, String> IDENTIFIER_REPLACEMENT = new ImmutableMap.Builder().put((Object)"EMPTY_LIST", (Object)"emptyList()").put((Object)"EMPTY_MAP", (Object)"emptyMap()").put((Object)"EMPTY_SET", (Object)"emptySet()").build();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        super.visitMemberSelectExpression(tree);
        String identifier = tree.identifier().name();
        boolean isCollectionsCall = tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "Collections".equals(((IdentifierTree)tree.expression()).name());
        boolean callEmptyConstant = identifier.startsWith("EMPTY_");
        if (isCollectionsCall && callEmptyConstant) {
            this.context.addIssue((Tree)tree, RULE, "Replace \"Collections." + identifier + "\" by \"Collections." + IDENTIFIER_REPLACEMENT.get(identifier) + "\".");
        }
    }
}

