/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S1699", priority=Priority.MAJOR, tags={"bug"})
public class ConstructorCallingOverridableCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            MethodTree methodTree = (MethodTree)tree;
            Symbol.TypeSymbol constructorType = (Symbol.TypeSymbol)this.getSemanticModel().getEnclosingClass(tree);
            if (!constructorType.isFinal()) {
                ConstructorBodyVisitor constructorBodyVisitor = new ConstructorBodyVisitor(constructorType);
                methodTree.block().accept((TreeVisitor)constructorBodyVisitor);
            }
        }
    }

    private class ConstructorBodyVisitor
    extends BaseTreeVisitor {
        private Symbol.TypeSymbol constructorType;

        public ConstructorBodyVisitor(Symbol.TypeSymbol constructorType) {
            this.constructorType = constructorType;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol symbol;
            IdentifierTree methodIdentifier = null;
            boolean isInvocationOnSelf = false;
            ExpressionTree methodSelect = tree.methodSelect();
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                methodIdentifier = (IdentifierTree)methodSelect;
                isInvocationOnSelf = true;
            } else if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)methodSelect;
                methodIdentifier = memberSelect.identifier();
                isInvocationOnSelf = this.isThisOrSuper(memberSelect.expression());
            }
            if (isInvocationOnSelf && (symbol = ConstructorCallingOverridableCheck.this.getSemanticModel().getReference(methodIdentifier)) != null && this.isOverridableMethod(symbol) && this.isMethodDefinedOnConstructedType(symbol)) {
                ConstructorCallingOverridableCheck.this.addIssue((Tree)tree, "Remove this call from a constructor to the overridable \"" + methodIdentifier.name() + "\" method.");
            }
            super.visitMethodInvocation(tree);
        }

        private boolean isThisOrSuper(ExpressionTree expression) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                String targetName = ((IdentifierTree)expression).name();
                return "this".equals(targetName) || "super".equals(targetName);
            }
            return false;
        }

        private boolean isMethodDefinedOnConstructedType(Symbol symbol) {
            Symbol.TypeSymbol methodEnclosingClass = symbol.enclosingClass();
            for (Type.ClassType superType : this.constructorType.superTypes()) {
                if (!superType.getSymbol().equals(methodEnclosingClass)) continue;
                return true;
            }
            return this.constructorType.equals(methodEnclosingClass);
        }

        private boolean isOverridableMethod(Symbol symbol) {
            Symbol.MethodSymbol methodSymbol;
            return symbol.isKind(16) && !(methodSymbol = (Symbol.MethodSymbol)symbol).isPrivate() && !methodSymbol.isFinal() && !methodSymbol.isStatic();
        }
    }
}

