/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2061", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class CustomSerializationMethodCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.getSymbol();
        if (this.hasSemantic() && this.isOwnedBySerializable(methodSymbol)) {
            if (this.hasSignature(methodSymbol, "writeObject", "java.io.ObjectOutputStream")) {
                this.checkPrivate(methodTree);
                this.checkNotStatic(methodTree);
            } else if (this.hasSignature(methodSymbol, "readObject", "java.io.ObjectInputStream")) {
                this.checkPrivate(methodTree);
                this.checkNotStatic(methodTree);
            } else if (this.hasSignature(methodSymbol, "readObjectNoData")) {
                this.checkPrivate(methodTree);
                this.checkNotStatic(methodTree);
            } else if (this.hasSignature(methodSymbol, "writeReplace")) {
                this.checkNotStatic(methodTree);
                this.checkReturnType(methodTree, "java.lang.Object");
            } else if (this.hasSignature(methodSymbol, "readResolve")) {
                this.checkNotStatic(methodTree);
                this.checkReturnType(methodTree, "java.lang.Object");
            }
        }
    }

    private boolean isOwnedBySerializable(Symbol.MethodSymbol methodSymbol) {
        Symbol.TypeSymbol owner = (Symbol.TypeSymbol)methodSymbol.owner();
        return owner.getType().isSubtypeOf("java.io.Serializable");
    }

    private boolean hasSignature(Symbol.MethodSymbol methodSymbol, String name, String paramType) {
        return name.equals(methodSymbol.getName()) && this.hasSingleParam(methodSymbol, paramType);
    }

    private boolean hasSignature(Symbol.MethodSymbol methodSymbol, String name) {
        return name.equals(methodSymbol.getName()) && methodSymbol.getParametersTypes().isEmpty();
    }

    private boolean hasSingleParam(Symbol.MethodSymbol methodSymbol, String searchedParamType) {
        List parametersTypes = methodSymbol.getParametersTypes();
        return parametersTypes.size() == 1 && ((Type)parametersTypes.get(0)).is(searchedParamType);
    }

    private void checkNotStatic(MethodTreeImpl methodTree) {
        Symbol.MethodSymbol methodSymbol = methodTree.getSymbol();
        if (methodSymbol.isStatic()) {
            this.addIssue((Tree)methodTree, "The \"static\" modifier should not be applied to \"" + methodSymbol.getName() + "\".");
        }
    }

    private void checkPrivate(MethodTreeImpl methodTree) {
        Symbol.MethodSymbol methodSymbol = methodTree.getSymbol();
        if (!methodSymbol.isPrivate()) {
            this.addIssue((Tree)methodTree, "Make \"" + methodSymbol.getName() + "\" \"private\".");
        }
    }

    private void checkReturnType(MethodTreeImpl methodTree, String requiredReturnType) {
        Symbol.MethodSymbol methodSymbol = methodTree.getSymbol();
        if (!methodSymbol.getReturnType().getType().is(requiredReturnType)) {
            this.addIssue((Tree)methodTree, "\"" + methodSymbol.getName() + "\" should return \"" + requiredReturnType + "\".");
        }
    }
}

