/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Cardinality;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.api.CheckMessage;

@Rule(key="S2253", cardinality=Cardinality.MULTIPLE, priority=Priority.MAJOR)
public class DisallowedMethodCheck
extends AbstractMethodDetection {
    @RuleProperty(key="className")
    private String className = "";
    @RuleProperty(key="methodName")
    private String methodName = "";
    @RuleProperty(key="argumentTypes")
    private String argumentTypes = "";

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        String[] args;
        if (StringUtils.isEmpty((String)this.methodName)) {
            return ImmutableList.of();
        }
        MethodInvocationMatcher invocationMatcher = MethodInvocationMatcher.create().name(this.methodName);
        if (StringUtils.isNotEmpty((String)this.className)) {
            invocationMatcher.typeDefinition(this.className);
        }
        for (String arg : args = StringUtils.split((String)this.argumentTypes, (String)",")) {
            invocationMatcher.addParameter(StringUtils.trim((String)arg));
        }
        return ImmutableList.of((Object)invocationMatcher);
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        this.context.addIssue((Tree)mit, new CheckMessage((Object)this, "Remove this forbidden call", new Object[0]));
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setArgumentTypes(String argumentTypes) {
        this.argumentTypes = argumentTypes;
    }
}

