/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2204", priority=Priority.BLOCKER, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class EqualsOnAtomicClassCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)this.equalsInvocationMatcher("java.util.concurrent.atomic.AtomicBoolean"), (Object)this.equalsInvocationMatcher("java.util.concurrent.atomic.AtomicInteger"), (Object)this.equalsInvocationMatcher("java.util.concurrent.atomic.AtomicLong"));
    }

    private MethodInvocationMatcher equalsInvocationMatcher(String fullyQualifiedName) {
        return MethodInvocationMatcher.create().callSite(TypeCriteria.is(fullyQualifiedName)).name("equals").addParameter("java.lang.Object");
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        this.addIssue((Tree)mit, "Use \".get()\" to retrieve the value and compare it instead.");
        super.onMethodFound(mit);
    }
}

