/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S1849", priority=Priority.BLOCKER, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class HasNextCallingNextCheck
extends SubscriptionBaseVisitor {
    private HasNextBodyVisitor hasNextBodyVisitor = new HasNextBodyVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.hasSemantic() && methodTree.block() != null && this.isHasNextMethod(methodTree)) {
            methodTree.block().accept((TreeVisitor)this.hasNextBodyVisitor);
        }
    }

    private boolean isHasNextMethod(MethodTree methodTree) {
        MethodTreeImpl method = (MethodTreeImpl)methodTree;
        return "hasNext".equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty() && this.isIteratorMethod((Symbol)method.getSymbol());
    }

    private boolean isIteratorMethod(Symbol method) {
        Symbol.TypeSymbol methodOwner = method.owner().enclosingClass();
        Set superTypes = methodOwner.superTypes();
        for (Type.ClassType classType : superTypes) {
            if (!classType.is("java.util.Iterator")) continue;
            return true;
        }
        return false;
    }

    private class HasNextBodyVisitor
    extends BaseTreeVisitor {
        private HasNextBodyVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            MethodInvocationTreeImpl invocation = (MethodInvocationTreeImpl)tree;
            Symbol method = invocation.getSymbol();
            if ("next".equals(method.getName()) && invocation.arguments().isEmpty() && HasNextCallingNextCheck.this.isIteratorMethod(method)) {
                HasNextCallingNextCheck.this.addIssue((Tree)tree, "Refactor the implementation of this \"Iterator.hasNext()\" method to not call \"Iterator.next()\".");
            }
            super.visitMethodInvocation(tree);
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

