/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2386", priority=Priority.CRITICAL, tags={"unpredictable"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class InterfaceStaticMutableMemberCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        for (Tree member : ((ClassTree)tree).members()) {
            VariableTreeImpl variableTree;
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !this.isStaticMember((VariableTree)(variableTree = (VariableTreeImpl)member)) || !this.isMutableMember(variableTree)) continue;
            this.addIssue((Tree)variableTree, MessageFormat.format("Move \"{0}\" to a class and lower its visibility", variableTree.simpleName().name()));
        }
    }

    private boolean isStaticMember(VariableTree variableTree) {
        return variableTree.modifiers().modifiers().contains(Modifier.STATIC);
    }

    private boolean isMutableMember(VariableTreeImpl variableTree) {
        return this.isArray(variableTree.type()) || this.isDateOrCollection(variableTree.getSymbol().getType());
    }

    private boolean isArray(Tree typeTree) {
        return typeTree.is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE});
    }

    private boolean isDateOrCollection(Type variableSymbolType) {
        return variableSymbolType.is("java.util.Date") || variableSymbolType.isSubtypeOf("java.util.Collection") && !variableSymbolType.isSubtypeOf("com.google.common.collect.ImmutableCollection");
    }
}

