/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaLexer;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="LeftCurlyBraceEndLineCheck", priority=Priority.MAJOR, tags={"convention"})
public class LeftCurlyBraceEndLineCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaPunctuator.LWING});
    }

    public void visitNode(AstNode node) {
        if (!LeftCurlyBraceEndLineCheck.isExcluded(node) && node.getPreviousAstNode().getLastToken() != null && node.getPreviousAstNode().getLastToken().getLine() != node.getTokenLine()) {
            this.getContext().createLineViolation((CodeCheck)this, "Move this left curly brace to the end of previous line of code.", node, new Object[0]);
        }
    }

    private static boolean isExcluded(AstNode node) {
        return node.getParent().is(new AstNodeType[]{Tree.Kind.NEW_ARRAY}) || LeftCurlyBraceEndLineCheck.isExcludedBlock(node.getParent());
    }

    private static boolean isExcludedBlock(AstNode node) {
        return LeftCurlyBraceEndLineCheck.isInitializer(node) || LeftCurlyBraceEndLineCheck.isBlock(node);
    }

    private static boolean isInitializer(AstNode node) {
        return node.is(new AstNodeType[]{Tree.Kind.INITIALIZER, Tree.Kind.STATIC_INITIALIZER});
    }

    private static boolean isBlock(AstNode node) {
        return node.getParent().is(new AstNodeType[]{JavaLexer.BLOCK_STATEMENTS});
    }
}

