/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2118", priority=Priority.CRITICAL, tags={"pitfall", "serialization"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class NonSerializableWriteCheck
extends SubscriptionBaseVisitor {
    private static final MethodInvocationMatcher WRITE_OBJECT_MATCHER = MethodInvocationMatcher.create().typeDefinition("java.io.ObjectOutputStream").name("writeObject").addParameter("java.lang.Object");
    private final List<Symbol> testedSymbols = Lists.newArrayList();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.INSTANCE_OF);
    }

    public void scanFile(JavaFileScannerContext context) {
        this.testedSymbols.clear();
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.visitMethodInvocation((MethodInvocationTree)tree);
            } else {
                this.visitInstanceOf((InstanceOfTree)tree);
            }
        }
    }

    private void visitInstanceOf(InstanceOfTree instanceOfTree) {
        ExpressionTree expression = instanceOfTree.expression();
        AbstractTypedTree testedType = (AbstractTypedTree)instanceOfTree.type();
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && testedType.getSymbolType().is("java.io.Serializable")) {
            this.testedSymbols.add(this.getSemanticModel().getReference((IdentifierTree)expression));
        }
    }

    private boolean isTestedSymbol(AbstractTypedTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = this.getSemanticModel().getReference((IdentifierTree)tree);
            return this.testedSymbols.contains(symbol);
        }
        return false;
    }

    private void visitMethodInvocation(MethodInvocationTree methodInvocation) {
        AbstractTypedTree argument;
        if (WRITE_OBJECT_MATCHER.matches(methodInvocation, this.getSemanticModel()) && !this.isAcceptableType((argument = (AbstractTypedTree)methodInvocation.arguments().get(0)).getSymbolType()) && !this.isTestedSymbol(argument)) {
            this.addIssue((Tree)methodInvocation, "Make the \"" + argument.getSymbolType() + "\" class \"Serializable\" or don't write it.");
        }
    }

    private boolean isAcceptableType(Type argType) {
        return argType.isSubtypeOf("java.io.Serializable") || argType.is("java.lang.Object") || argType.isPrimitive() || !argType.isTagged(10);
    }
}

