/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2156", priority=Priority.MAJOR, tags={"confusing"})
public class ProtectedMemberInFinalClassCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.modifiers().modifiers().contains(Modifier.FINAL)) {
            for (Tree member : classTree.members()) {
                if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                    VariableTree variableTree = (VariableTree)member;
                    this.checkMemberModifier(variableTree.modifiers());
                    continue;
                }
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
                MethodTree methodTree = (MethodTree)member;
                this.checkMemberModifier(methodTree.modifiers());
            }
        }
    }

    private void checkMemberModifier(ModifiersTree modifiers) {
        if (modifiers.modifiers().contains(Modifier.PROTECTED)) {
            this.addIssue((Tree)modifiers, "Remove this \"protected\" modifier.");
        }
    }
}

