/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2245", priority=Priority.CRITICAL, tags={"cert", "cwe", "sans-top25-2011", "security"})
public class PseudoRandomCheck
extends SubscriptionBaseVisitor {
    private MethodInvocationMatcher methodInvocationMatcher = MethodInvocationMatcher.create().typeDefinition("java.lang.Math").name("random");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.NEW_CLASS, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (this.isMathRandom(tree) || this.isJavaUtilRandom(tree)) {
            this.addIssue(tree, "Use a cryptographically strong random number generator (RNG) like \"java.security.SecureRandom\" in place of this PRNG");
        }
    }

    private boolean isMathRandom(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && this.hasSemantic() && this.methodInvocationMatcher.matches((MethodInvocationTree)tree, this.getSemanticModel());
    }

    private boolean isJavaUtilRandom(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && ((AbstractTypedTree)tree).getSymbolType().is("java.util.Random");
    }
}

